/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models.gear;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.renderers.block.BlockRenderer;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ModelWand
extends ModelBase {
    ModelRenderer Rod;
    ModelRenderer Focus;
    ModelRenderer Cap;
    ModelRenderer CapBottom;
    private final RenderBlocks renderBlocks = new RenderBlocks();

    public ModelWand() {
        this.textureWidth = 32;
        this.textureHeight = 32;
        this.Cap = new ModelRenderer((ModelBase)this, 0, 0);
        this.Cap.addBox(-1.0f, -1.0f, -1.0f, 2, 2, 2);
        this.Cap.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.Cap.setTextureSize(64, 32);
        this.Cap.mirror = true;
        this.setRotation(this.Cap, 0.0f, 0.0f, 0.0f);
        this.CapBottom = new ModelRenderer((ModelBase)this, 0, 0);
        this.CapBottom.addBox(-1.0f, -1.0f, -1.0f, 2, 2, 2);
        this.CapBottom.setRotationPoint(0.0f, 20.0f, 0.0f);
        this.CapBottom.setTextureSize(64, 32);
        this.CapBottom.mirror = true;
        this.setRotation(this.CapBottom, 0.0f, 0.0f, 0.0f);
        this.Rod = new ModelRenderer((ModelBase)this, 0, 8);
        this.Rod.addBox(-1.0f, -1.0f, -1.0f, 2, 18, 2);
        this.Rod.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.Rod.setTextureSize(64, 32);
        this.Rod.mirror = true;
        this.setRotation(this.Rod, 0.0f, 0.0f, 0.0f);
        this.Focus = new ModelRenderer((ModelBase)this, 0, 0);
        this.Focus.addBox(-3.0f, -6.0f, -3.0f, 6, 6, 6);
        this.Focus.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.Focus.setTextureSize(64, 32);
        this.Focus.mirror = true;
        this.setRotation(this.Focus, 0.0f, 0.0f, 0.0f);
    }

    public void render(ItemStack wandStack) {
        int rot;
        int l;
        if (RenderManager.instance.renderEngine == null) {
            return;
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.getItem();
        ItemStack focusStack = wand.getFocusItem(wandStack);
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        boolean staff = wand.isStaff(wandStack);
        boolean runes = wand.hasRunes(wandStack);
        Minecraft.getMinecraft().renderEngine.bindTexture(wand.getRod(wandStack).getTexture());
        GL11.glPushMatrix();
        if (staff) {
            GL11.glTranslated((double)0.0, (double)0.2, (double)0.0);
        }
        GL11.glPushMatrix();
        if (wand.getRod(wandStack).isGlowing()) {
            int j = (int)(200.0f + MathHelper.sin((float)player.ticksExisted) * 5.0f + 5.0f);
            int k = j % 65536;
            l = j / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
        }
        if (staff) {
            GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
            GL11.glScaled((double)1.2, (double)2.0, (double)1.2);
        }
        this.Rod.render(0.0625f);
        if (wand.getRod(wandStack).isGlowing()) {
            int i = player.getBrightnessForRender(0.0f);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        }
        GL11.glPopMatrix();
        Minecraft.getMinecraft().renderEngine.bindTexture(wand.getCap(wandStack).getTexture());
        GL11.glPushMatrix();
        if (staff) {
            GL11.glScaled((double)1.3, (double)1.1, (double)1.3);
        } else {
            GL11.glScaled((double)1.2, (double)1.0, (double)1.2);
        }
        if (wand.isSceptre(wandStack)) {
            GL11.glPushMatrix();
            GL11.glScaled((double)1.3, (double)1.3, (double)1.3);
            this.Cap.render(0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.3, (double)0.0);
            GL11.glScaled((double)1.0, (double)0.66, (double)1.0);
            this.Cap.render(0.0625f);
            GL11.glPopMatrix();
        } else {
            this.Cap.render(0.0625f);
        }
        if (staff) {
            GL11.glTranslated((double)0.0, (double)0.225, (double)0.0);
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)0.66, (double)1.0);
            this.Cap.render(0.0625f);
            GL11.glPopMatrix();
            GL11.glTranslated((double)0.0, (double)0.65, (double)0.0);
        }
        this.CapBottom.render(0.0625f);
        GL11.glPopMatrix();
        if (wand.getFocus(wandStack) != null) {
            if (wand.getFocus(wandStack).getOrnament(focusStack) != null) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Tessellator tessellator = Tessellator.instance;
                IIcon icon = wand.getFocus(wandStack).getOrnament(focusStack);
                float f1 = icon.getMaxU();
                float f2 = icon.getMinV();
                float f3 = icon.getMinU();
                float f4 = icon.getMaxV();
                RenderManager.instance.renderEngine.bindTexture(TextureMap.locationItemsTexture);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-0.25f, (float)-0.1f, (float)0.0275f);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)f1, (float)f2, (float)f3, (float)f4, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.1f);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-0.25f, (float)-0.1f, (float)0.0275f);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)f1, (float)f2, (float)f3, (float)f4, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.1f);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            float alpha = 0.95f;
            if (wand.getFocus(wandStack).getFocusDepthLayerIcon(focusStack) != null) {
                GL11.glPushMatrix();
                if (staff) {
                    GL11.glTranslatef((float)0.0f, (float)-0.15f, (float)0.0f);
                    GL11.glScaled((double)0.165, (double)0.1765, (double)0.165);
                } else {
                    GL11.glTranslatef((float)0.0f, (float)-0.09f, (float)0.0f);
                    GL11.glScaled((double)0.16, (double)0.16, (double)0.16);
                }
                Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
                this.renderBlocks.setRenderBoundsFromBlock(Blocks.stone);
                BlockRenderer.drawFaces(this.renderBlocks, null, wand.getFocus(wandStack).getFocusDepthLayerIcon(focusStack), false);
                GL11.glPopMatrix();
                alpha = 0.6f;
            }
            if (Thaumcraft.isHalloween) {
                UtilsFX.bindTexture("textures/models/spec_h.png");
            } else {
                UtilsFX.bindTexture("textures/models/wand.png");
            }
            GL11.glPushMatrix();
            if (staff) {
                GL11.glTranslatef((float)0.0f, (float)-0.0475f, (float)0.0f);
                GL11.glScaled((double)0.525, (double)0.5525, (double)0.525);
            } else {
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            }
            Color c = new Color(wand.getFocus(wandStack).getFocusColor(focusStack));
            GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)alpha);
            int j = (int)(195.0f + MathHelper.sin((float)((float)player.ticksExisted / 3.0f)) * 10.0f + 10.0f);
            int k = j % 65536;
            int l2 = j / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)k / 1.0f), (float)((float)l2 / 1.0f));
            this.Focus.render(0.0625f);
            GL11.glPopMatrix();
        }
        if (wand.isSceptre(wandStack)) {
            GL11.glPushMatrix();
            int j = 200;
            int k = j % 65536;
            l = j / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
            GL11.glBlendFunc((int)770, (int)1);
            for (rot = 0; rot < 10; ++rot) {
                GL11.glPushMatrix();
                GL11.glRotated((double)(36 * rot + player.ticksExisted), (double)0.0, (double)1.0, (double)0.0);
                this.drawRune(0.16, -0.01f, -0.125, rot, (EntityPlayer)player);
                GL11.glPopMatrix();
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPopMatrix();
        }
        if (runes) {
            GL11.glPushMatrix();
            int j = 200;
            int k = j % 65536;
            l = j / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
            GL11.glBlendFunc((int)770, (int)1);
            for (rot = 0; rot < 4; ++rot) {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                for (int a = 0; a < 14; ++a) {
                    int rune = (a + rot * 3) % 16;
                    this.drawRune(0.36 + (double)a * 0.14, -0.01f, -0.08, rune, (EntityPlayer)player);
                }
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void drawRune(double x, double y, double z, int rune, EntityPlayer player) {
        GL11.glPushMatrix();
        UtilsFX.bindTexture("textures/misc/script.png");
        float r = MathHelper.sin((float)((float)(player.ticksExisted + rune * 5) / 5.0f)) * 0.1f + 0.88f;
        float g = MathHelper.sin((float)((float)(player.ticksExisted + rune * 5) / 7.0f)) * 0.1f + 0.63f;
        float alpha = MathHelper.sin((float)((float)(player.ticksExisted + rune * 5) / 10.0f)) * 0.2f;
        GL11.glColor4f((float)r, (float)g, (float)0.2f, (float)(alpha + 0.6f));
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)x, (double)y, (double)z);
        Tessellator tessellator = Tessellator.instance;
        float var8 = 0.0625f * (float)rune;
        float var9 = var8 + 0.0625f;
        float var10 = 0.0f;
        float var11 = 1.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r, g, 0.2f, alpha + 0.6f);
        tessellator.addVertexWithUV(-0.06 - (double)(alpha / 40.0f), 0.06 + (double)(alpha / 40.0f), 0.0, (double)var9, (double)var11);
        tessellator.addVertexWithUV(0.06 + (double)(alpha / 40.0f), 0.06 + (double)(alpha / 40.0f), 0.0, (double)var9, (double)var10);
        tessellator.addVertexWithUV(0.06 + (double)(alpha / 40.0f), -0.06 - (double)(alpha / 40.0f), 0.0, (double)var8, (double)var10);
        tessellator.addVertexWithUV(-0.06 - (double)(alpha / 40.0f), -0.06 - (double)(alpha / 40.0f), 0.0, (double)var8, (double)var11);
        tessellator.draw();
        GL11.glPopMatrix();
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5) {
        super.setRotationAngles(f, f1, f2, f3, f4, f5, null);
    }
}

