/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models.entities;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import thaumcraft.common.entities.monster.EntityPech;

public class ModelPech
extends ModelBase {
    ModelRenderer Body;
    ModelRenderer RightLeg;
    ModelRenderer LeftLeg;
    ModelRenderer Head;
    ModelRenderer Jowls;
    ModelRenderer LowerPack;
    ModelRenderer UpperPack;
    public ModelRenderer RightArm;
    ModelRenderer LeftArm;

    public ModelPech() {
        this.textureWidth = 128;
        this.textureHeight = 64;
        this.Body = new ModelRenderer((ModelBase)this, 34, 12);
        this.Body.addBox(-3.0f, 0.0f, 0.0f, 6, 10, 6);
        this.Body.setRotationPoint(0.0f, 9.0f, -3.0f);
        this.Body.setTextureSize(128, 64);
        this.Body.mirror = true;
        this.setRotation(this.Body, 0.3129957f, 0.0f, 0.0f);
        this.RightLeg = new ModelRenderer((ModelBase)this, 35, 1);
        this.RightLeg.mirror = true;
        this.RightLeg.addBox(-2.9f, 0.0f, 0.0f, 3, 6, 3);
        this.RightLeg.setRotationPoint(0.0f, 18.0f, 0.0f);
        this.RightLeg.setTextureSize(128, 64);
        this.RightLeg.mirror = true;
        this.setRotation(this.RightLeg, 0.0f, 0.0f, 0.0f);
        this.RightLeg.mirror = false;
        this.LeftLeg = new ModelRenderer((ModelBase)this, 35, 1);
        this.LeftLeg.addBox(-0.1f, 0.0f, 0.0f, 3, 6, 3);
        this.LeftLeg.setRotationPoint(0.0f, 18.0f, 0.0f);
        this.LeftLeg.setTextureSize(128, 64);
        this.LeftLeg.mirror = true;
        this.setRotation(this.LeftLeg, 0.0f, 0.0f, 0.0f);
        this.Head = new ModelRenderer((ModelBase)this, 2, 11);
        this.Head.addBox(-3.5f, -5.0f, -5.0f, 7, 5, 5);
        this.Head.setRotationPoint(0.0f, 8.0f, 0.0f);
        this.Head.setTextureSize(128, 64);
        this.Head.mirror = true;
        this.setRotation(this.Head, 0.0f, 0.0f, 0.0f);
        this.Jowls = new ModelRenderer((ModelBase)this, 1, 21);
        this.Jowls.addBox(-4.0f, -1.0f, -6.0f, 8, 3, 5);
        this.Jowls.setRotationPoint(0.0f, 8.0f, 0.0f);
        this.Jowls.setTextureSize(128, 64);
        this.Jowls.mirror = true;
        this.setRotation(this.Jowls, 0.0f, 0.0f, 0.0f);
        this.LowerPack = new ModelRenderer((ModelBase)this, 0, 0);
        this.LowerPack.addBox(-5.0f, 0.0f, 0.0f, 10, 5, 5);
        this.LowerPack.setRotationPoint(0.0f, 10.0f, 3.5f);
        this.LowerPack.setTextureSize(128, 64);
        this.LowerPack.mirror = true;
        this.setRotation(this.LowerPack, 0.3013602f, 0.0f, 0.0f);
        this.UpperPack = new ModelRenderer((ModelBase)this, 64, 1);
        this.UpperPack.addBox(-7.5f, -14.0f, 0.0f, 15, 14, 11);
        this.UpperPack.setRotationPoint(0.0f, 10.0f, 3.0f);
        this.UpperPack.setTextureSize(128, 64);
        this.UpperPack.mirror = true;
        this.setRotation(this.UpperPack, 0.4537856f, 0.0f, 0.0f);
        this.RightArm = new ModelRenderer((ModelBase)this, 52, 2);
        this.RightArm.mirror = true;
        this.RightArm.addBox(-2.0f, 0.0f, -1.0f, 2, 6, 2);
        this.RightArm.setRotationPoint(-3.0f, 10.0f, -1.0f);
        this.RightArm.setTextureSize(128, 64);
        this.RightArm.mirror = true;
        this.setRotation(this.RightArm, 0.0f, 0.0f, 0.0f);
        this.RightArm.mirror = false;
        this.LeftArm = new ModelRenderer((ModelBase)this, 52, 2);
        this.LeftArm.addBox(0.0f, 0.0f, -1.0f, 2, 6, 2);
        this.LeftArm.setRotationPoint(3.0f, 10.0f, -1.0f);
        this.LeftArm.setTextureSize(128, 64);
        this.LeftArm.mirror = true;
        this.setRotation(this.LeftArm, 0.0f, 0.0f, 0.0f);
    }

    public void render(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.setRotationAngles(par2, par3, par4, par5, par6, par7, par1Entity);
        this.Body.render(par7);
        this.RightLeg.render(par7);
        this.LeftLeg.render(par7);
        this.Head.render(par7);
        this.Jowls.render(par7);
        this.LowerPack.render(par7);
        this.UpperPack.render(par7);
        this.RightArm.render(par7);
        this.LeftArm.render(par7);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, Entity entity) {
        this.Head.rotateAngleY = par4 / 57.295776f;
        this.Head.rotateAngleX = par5 / 57.295776f;
        float mumble = 0.0f;
        if (entity instanceof EntityPech) {
            mumble = ((EntityPech)entity).mumble;
        }
        this.Jowls.rotateAngleY = this.Head.rotateAngleY;
        this.Jowls.rotateAngleX = this.Head.rotateAngleX + (0.2617994f + MathHelper.cos((float)(par1 * 0.6662f)) * par2 * 0.25f) + 0.34906587f * Math.abs(MathHelper.sin((float)mumble));
        this.RightArm.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f + (float)Math.PI)) * 2.0f * par2 * 0.5f;
        this.LeftArm.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.5f;
        this.RightArm.rotateAngleZ = 0.0f;
        this.LeftArm.rotateAngleZ = 0.0f;
        this.RightLeg.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f)) * 1.4f * par2;
        this.LeftLeg.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
        this.RightLeg.rotateAngleY = 0.0f;
        this.LeftLeg.rotateAngleY = 0.0f;
        this.LowerPack.rotateAngleY = MathHelper.cos((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.125f;
        this.LowerPack.rotateAngleZ = MathHelper.cos((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.125f;
        if (this.isRiding) {
            this.RightArm.rotateAngleX += -0.62831855f;
            this.LeftArm.rotateAngleX += -0.62831855f;
            this.RightLeg.rotateAngleX = -1.2566371f;
            this.LeftLeg.rotateAngleX = -1.2566371f;
            this.RightLeg.rotateAngleY = 0.31415927f;
            this.LeftLeg.rotateAngleY = -0.31415927f;
        }
        this.RightArm.rotateAngleY = 0.0f;
        this.LeftArm.rotateAngleY = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.RightArm.rotateAngleY += this.Body.rotateAngleY;
            this.LeftArm.rotateAngleY += this.Body.rotateAngleY;
            this.LeftArm.rotateAngleX += this.Body.rotateAngleY;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin((float)(f6 * (float)Math.PI));
            float f8 = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -(this.Head.rotateAngleX - 0.7f) * 0.75f;
            this.RightArm.rotateAngleX = (float)((double)this.RightArm.rotateAngleX - ((double)f7 * 1.2 + (double)f8));
            this.RightArm.rotateAngleY += this.Body.rotateAngleY * 2.0f;
            this.RightArm.rotateAngleZ = MathHelper.sin((float)(this.onGround * (float)Math.PI)) * -0.4f;
        }
        if (entity.isSneaking()) {
            this.RightArm.rotateAngleX += 0.4f;
            this.LeftArm.rotateAngleX += 0.4f;
        }
        this.RightArm.rotateAngleZ += MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.LeftArm.rotateAngleZ -= MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.RightArm.rotateAngleX += MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
        this.LeftArm.rotateAngleX -= MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
    }
}

