/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.tiles.TileBanner;

public class ItemBannerRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (!item.hasTagCompound() || item.getItemDamage() != 8) {
            return false;
        }
        return item.stackTagCompound.getString("aspect") != null && item.stackTagCompound.getByte("color") >= 0;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Minecraft mc = Minecraft.getMinecraft();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean var11 = false;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GL11.glRotatef((float)((float)var11), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-1.0f, (float)-0.5f);
        TileBanner tb = new TileBanner();
        tb.setColor(item.stackTagCompound.getByte("color"));
        if (item.stackTagCompound.getString("aspect") != null) {
            tb.setAspect(Aspect.getAspect(item.stackTagCompound.getString("aspect")));
        }
        TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)tb, 0.0, 0.0, 0.0, 0.0f);
        GL11.glPopMatrix();
    }
}

