/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.EntityCultistCleric;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;

@SideOnly(value=Side.CLIENT)
public class RenderCultist
extends RenderBiped {
    private static final ResourceLocation skin = new ResourceLocation("thaumcraft", "textures/models/cultist.png");

    public RenderCultist() {
        super(new ModelBiped(), 0.5f);
    }

    protected ResourceLocation getEntityTexture(EntityLiving p_110775_1_) {
        return skin;
    }

    protected void preRenderCallback(EntityLivingBase par1EntityLiving, float par2) {
        if (par1EntityLiving instanceof EntityCultistLeader) {
            BossStatus.setBossStatus((IBossDisplayData)((EntityCultistLeader)par1EntityLiving), (boolean)false);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
        }
    }

    public void doRender(Entity entity, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        boolean rit;
        GL11.glPushMatrix();
        float bob = 0.0f;
        boolean bl = rit = entity instanceof EntityCultistCleric && ((EntityCultistCleric)entity).getIsRitualist();
        if (rit) {
            int val = new Random(entity.getEntityId()).nextInt(1000);
            float c = (float)((EntityCultistCleric)entity).ticksExisted + p_76986_9_ + (float)val;
            bob = MathHelper.sin((float)(c / 9.0f)) * 0.1f + 0.21f;
            GL11.glTranslated((double)0.0, (double)bob, (double)0.0);
        }
        super.doRender(entity, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
        if (rit) {
            GL11.glPushMatrix();
            this.drawFloatyLine(entity.posX, entity.posY + (double)(entity.getEyeHeight() * 1.2f), entity.posZ, (double)((EntityCultistCleric)entity).getHomePosition().posX + 0.5, (double)((EntityCultistCleric)entity).getHomePosition().posY + 1.5 - (double)bob, (double)((EntityCultistCleric)entity).getHomePosition().posZ + 0.5, p_76986_9_, 0x110011, "textures/misc/wispy.png", -0.03f, (float)Math.min(((EntityCultistCleric)entity).ticksExisted, 10) / 10.0f, 0.25f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void drawFloatyLine(double x, double y, double z, double x2, double y2, double z2, float partialTicks, int color, String texture, float speed, float distance, float width) {
        float f13;
        double dz;
        double dy;
        double dx;
        float f3;
        float f2a;
        float f2;
        EntityLivingBase player = Minecraft.getMinecraft().renderViewEntity;
        double iPX = player.prevPosX + (player.posX - player.prevPosX) * (double)partialTicks;
        double iPY = player.prevPosY + (player.posY - player.prevPosY) * (double)partialTicks;
        double iPZ = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)partialTicks;
        double ePX = x2;
        double ePY = y2;
        double ePZ = z2;
        GL11.glTranslated((double)(-iPX + ePX), (double)(-iPY + ePY), (double)(-iPZ + ePZ));
        float time = System.nanoTime() / 30000000L;
        Color co = new Color(color);
        float r = (float)co.getRed() / 255.0f;
        float g = (float)co.getGreen() / 255.0f;
        float b = (float)co.getBlue() / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        double ds1x = ePX;
        double ds1y = ePY;
        double ds1z = ePZ;
        double dd1x = x;
        double dd1y = y;
        double dd1z = z;
        double dc1x = (float)(dd1x - ds1x);
        double dc1y = (float)(dd1y - ds1y);
        double dc1z = (float)(dd1z - ds1z);
        UtilsFX.bindTexture(texture);
        tessellator.startDrawing(5);
        double dx2 = 0.0;
        double dy2 = 0.0;
        double dz2 = 0.0;
        double d3 = x - ePX;
        double d4 = y - ePY;
        double d5 = z - ePZ;
        float dist = MathHelper.sqrt_double((double)(d3 * d3 + d4 * d4 + d5 * d5));
        float blocks = Math.round(dist);
        float length = blocks * ((float)Config.golemLinkQuality / 2.0f);
        float f9 = 0.0f;
        float f10 = 1.0f;
        int i = 0;
        while ((float)i <= length * distance) {
            f2 = (float)i / length;
            f2a = (float)i * 1.5f / length;
            f2a = Math.min(0.75f, f2a);
            f3 = 1.0f - Math.abs((float)i - length / 2.0f) / (length / 2.0f);
            dx = dc1x + (double)(MathHelper.sin((float)((float)((z % 16.0 + (double)(dist * (1.0f - f2) * (float)Config.golemLinkQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 4.0))) * 0.5f * f3);
            dy = dc1y + (double)(MathHelper.sin((float)((float)((x % 16.0 + (double)(dist * (1.0f - f2) * (float)Config.golemLinkQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 3.0))) * 0.5f * f3);
            dz = dc1z + (double)(MathHelper.sin((float)((float)((y % 16.0 + (double)(dist * (1.0f - f2) * (float)Config.golemLinkQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 2.0))) * 0.5f * f3);
            tessellator.setColorRGBA_F(r, g, b, 0.8f);
            f13 = (1.0f - f2) * dist - time * speed;
            tessellator.addVertexWithUV(dx * (double)f2, dy * (double)f2 - (double)width, dz * (double)f2, (double)f13, (double)f10);
            tessellator.addVertexWithUV(dx * (double)f2, dy * (double)f2 + (double)width, dz * (double)f2, (double)f13, (double)f9);
            ++i;
        }
        tessellator.draw();
        tessellator.startDrawing(5);
        i = 0;
        while ((float)i <= length * distance) {
            f2 = (float)i / length;
            f2a = (float)i * 1.5f / length;
            f2a = Math.min(0.75f, f2a);
            f3 = 1.0f - Math.abs((float)i - length / 2.0f) / (length / 2.0f);
            dx = dc1x + (double)(MathHelper.sin((float)((float)((z % 16.0 + (double)(dist * (1.0f - f2) * (float)Config.golemLinkQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 4.0))) * 0.5f * f3);
            dy = dc1y + (double)(MathHelper.sin((float)((float)((x % 16.0 + (double)(dist * (1.0f - f2) * (float)Config.golemLinkQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 3.0))) * 0.5f * f3);
            dz = dc1z + (double)(MathHelper.sin((float)((float)((y % 16.0 + (double)(dist * (1.0f - f2) * (float)Config.golemLinkQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 2.0))) * 0.5f * f3);
            tessellator.setColorRGBA_F(r, g, b, 0.8f);
            f13 = (1.0f - f2) * dist - time * speed;
            tessellator.addVertexWithUV(dx * (double)f2 - (double)width, dy * (double)f2, dz * (double)f2, (double)f13, (double)f10);
            tessellator.addVertexWithUV(dx * (double)f2 + (double)width, dy * (double)f2, dz * (double)f2, (double)f13, (double)f9);
            ++i;
        }
        tessellator.draw();
        GL11.glDisable((int)3042);
    }
}

