/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.client.renderers.block.BlockRenderer;
import thaumcraft.common.blocks.BlockTaintFibres;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;

public class BlockTaintFibreRenderer
extends BlockRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean fix = true;
        int metadata = world.getBlockMetadata(x, y, z);
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.setRenderBoundsFromBlock(block);
        BlockTaintFibreRenderer.setBrightness(world, x, y, z, block);
        Tessellator t = Tessellator.instance;
        if (metadata <= 4) {
            if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true) && world.getBlock(x - 1, y, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceXPos(block, (double)((float)x - 0.995f), (double)y, (double)z, block.getIcon(0, 0));
            }
            if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true) && world.getBlock(x + 1, y, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceXNeg(block, (double)((float)x + 0.995f), (double)y, (double)z, block.getIcon(0, 0));
            }
            if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true) && world.getBlock(x, y, z - 1) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceZPos(block, (double)x, (double)y, (double)((float)z - 0.995f), block.getIcon(0, 0));
            }
            if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true) && world.getBlock(x, y, z + 1) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceZNeg(block, (double)x, (double)y, (double)((float)z + 0.995f), block.getIcon(0, 0));
            }
            if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true) && world.getBlock(x, y - 1, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceYPos(block, (double)x, (double)((float)y - 0.995f), (double)z, block.getIcon(0, 0));
            }
            if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true) && world.getBlock(x, y + 1, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceYNeg(block, (double)x, (double)((float)y + 0.995f), (double)z, block.getIcon(0, 0));
            }
        }
        if (metadata == 0 && Config.glowyTaint) {
            t.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            t.setBrightness(200);
            if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true) && world.getBlock(x - 1, y, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceXPos(block, (double)((float)x - 0.98f), (double)y, (double)z, ((BlockTaintFibres)block).getOverlayBlockTexture(x, y, z, 4));
            }
            if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true) && world.getBlock(x + 1, y, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceXNeg(block, (double)((float)x + 0.98f), (double)y, (double)z, ((BlockTaintFibres)block).getOverlayBlockTexture(x, y, z, 5));
            }
            if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true) && world.getBlock(x, y, z - 1) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceZPos(block, (double)x, (double)y, (double)((float)z - 0.98f), ((BlockTaintFibres)block).getOverlayBlockTexture(x, y, z, 2));
            }
            if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true) && world.getBlock(x, y, z + 1) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceZNeg(block, (double)x, (double)y, (double)((float)z + 0.98f), ((BlockTaintFibres)block).getOverlayBlockTexture(x, y, z, 3));
            }
            if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true) && world.getBlock(x, y - 1, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceYPos(block, (double)x, (double)((float)y - 0.98f), (double)z, ((BlockTaintFibres)block).getOverlayBlockTexture(x, y, z, 0));
            }
            if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true) && world.getBlock(x, y + 1, z) != ConfigBlocks.blockTaint) {
                fix = false;
                renderer.renderFaceYNeg(block, (double)x, (double)((float)y + 0.98f), (double)z, ((BlockTaintFibres)block).getOverlayBlockTexture(x, y, z, 1));
            }
        }
        if ((metadata == 1 || metadata == 2) && world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true)) {
            double d0 = x;
            double d1 = y;
            double d2 = z;
            long i1 = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
            i1 = i1 * i1 * 42317861L + i1 * 11L;
            fix = false;
            renderer.drawCrossedSquares(block.getIcon(0, metadata), d0 += ((double)((float)(i1 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5, d1, d2 += ((double)((float)(i1 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5, 1.0f);
        }
        if (metadata == 3 || metadata == 4) {
            fix = false;
            renderer.renderCrossedSquares(block, x, y, z);
        }
        if (fix) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            renderer.setRenderBoundsFromBlock(block);
            renderer.renderStandardBlock(block, x, y, z);
        }
        renderer.clearOverrideBlockTexture();
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.setRenderBoundsFromBlock(block);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ConfigBlocks.blockTaintFibreRI;
    }
}

