/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.renderers.block.BlockRenderer;
import thaumcraft.common.blocks.BlockCustomOreItem;
import thaumcraft.common.blocks.BlockLifter;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileLifter;

public class BlockLifterRenderer
extends BlockRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.setRenderBoundsFromBlock(block);
        BlockLifterRenderer.drawFaces(renderer, block, ((BlockLifter)block).iconBottom, ((BlockLifter)block).iconTop, ((BlockLifter)block).iconSide, ((BlockLifter)block).iconSide, ((BlockLifter)block).iconSide, ((BlockLifter)block).iconSide, false);
        Color c = new Color(BlockCustomOreItem.colors[4]);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        GL11.glColor3f((float)r, (float)g, (float)b);
        block.setBlockBounds(0.01f, 0.9f, 0.01f, 0.99f, 0.99f, 0.99f);
        renderer.setRenderBoundsFromBlock(block);
        BlockLifterRenderer.drawFaces(renderer, block, ((BlockLifter)block).iconGlow, false);
        c = new Color(BlockCustomOreItem.colors[5]);
        r = (float)c.getRed() / 255.0f;
        g = (float)c.getGreen() / 255.0f;
        b = (float)c.getBlue() / 255.0f;
        GL11.glColor3f((float)r, (float)g, (float)b);
        block.setBlockBounds(0.01f, 0.1f, 0.01f, 0.99f, 0.9f, 0.99f);
        renderer.setRenderBoundsFromBlock(block);
        BlockLifterRenderer.drawFaces(renderer, block, ((BlockLifter)block).iconGlow, false);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int bb = BlockLifterRenderer.setBrightness(world, x, y, z, block);
        int metadata = world.getBlockMetadata(x, y, z);
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.setRenderBoundsFromBlock(block);
        renderer.renderStandardBlock(block, x, y, z);
        Tessellator t = Tessellator.instance;
        t.setColorOpaque_I(BlockCustomOreItem.colors[4]);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileLifter && !((TileLifter)te).gettingPower()) {
            bb = 180;
        }
        t.setBrightness(bb);
        if (block.shouldSideBeRendered(world, x, y + 1, z, 6)) {
            renderer.renderFaceYPos(block, (double)x, (double)((float)y - 0.01f), (double)z, ((BlockLifter)block).iconGlow);
        }
        t.setColorOpaque_I(0xDD11FF);
        if (block.shouldSideBeRendered(world, x + 1, y, z, 6)) {
            renderer.renderFaceXPos(block, (double)((float)x - 0.01f), (double)y, (double)z, ((BlockLifter)block).iconGlow);
        }
        if (block.shouldSideBeRendered(world, x - 1, y, z, 6)) {
            renderer.renderFaceXNeg(block, (double)((float)x + 0.01f), (double)y, (double)z, ((BlockLifter)block).iconGlow);
        }
        if (block.shouldSideBeRendered(world, x, y, z + 1, 6)) {
            renderer.renderFaceZPos(block, (double)x, (double)y, (double)((float)z - 0.01f), ((BlockLifter)block).iconGlow);
        }
        if (block.shouldSideBeRendered(world, x, y, z - 1, 6)) {
            renderer.renderFaceZNeg(block, (double)x, (double)y, (double)((float)z + 0.01f), ((BlockLifter)block).iconGlow);
        }
        renderer.clearOverrideBlockTexture();
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.setRenderBoundsFromBlock(block);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ConfigBlocks.blockLifterRI;
    }
}

