/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.lib.utils.InventoryUtils;

@SideOnly(value=Side.CLIENT)
public class GuiResearchPopup
extends Gui {
    private Minecraft theGame;
    private int windowWidth;
    private int windowHeight;
    private ArrayList<ResearchItem> theResearch = new ArrayList();
    private long researchTime;
    private RenderItem itemRender;
    private static final ResourceLocation texture = new ResourceLocation("textures/gui/achievement/achievement_background.png");

    public GuiResearchPopup(Minecraft par1Minecraft) {
        this.theGame = par1Minecraft;
        this.itemRender = new RenderItem();
    }

    public void queueResearchInformation(ResearchItem research) {
        if (this.researchTime == 0L) {
            this.researchTime = Minecraft.getSystemTime();
        }
        this.theResearch.add(research);
        GuiResearchBrowser.lastX = research.displayColumn;
        GuiResearchBrowser.lastY = research.displayRow;
    }

    private void updateResearchWindowScale() {
        GL11.glViewport((int)0, (int)0, (int)this.theGame.displayWidth, (int)this.theGame.displayHeight);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.windowWidth = this.theGame.displayWidth;
        this.windowHeight = this.theGame.displayHeight;
        ScaledResolution var1 = new ScaledResolution(Minecraft.getMinecraft(), this.theGame.displayWidth, this.theGame.displayHeight);
        this.windowWidth = var1.getScaledWidth();
        this.windowHeight = var1.getScaledHeight();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.windowWidth, (double)this.windowHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void updateResearchWindow() {
        if (this.theResearch.size() > 0 && this.researchTime != 0L) {
            double var1 = (double)(Minecraft.getSystemTime() - this.researchTime) / 3000.0;
            if (var1 < 0.0 || var1 > 1.0) {
                this.theResearch.remove(0);
                this.researchTime = this.theResearch.size() > 0 ? Minecraft.getSystemTime() : 0L;
            } else {
                this.updateResearchWindowScale();
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                double var3 = var1 * 2.0;
                if (var3 > 1.0) {
                    var3 = 2.0 - var3;
                }
                var3 *= 4.0;
                if ((var3 = 1.0 - var3) < 0.0) {
                    var3 = 0.0;
                }
                var3 *= var3;
                var3 *= var3;
                int var5 = 0;
                int var6 = 0 - (int)(var3 * 36.0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                this.theGame.getTextureManager().bindTexture(texture);
                GL11.glDisable((int)2896);
                this.drawTexturedModalRect(var5, var6, 96, 202, 160, 32);
                this.theGame.fontRenderer.drawString("Research Completed!", var5 + 30, var6 + 7, -256);
                int offset = this.theGame.fontRenderer.getStringWidth(this.theResearch.get(0).getName());
                if (offset <= 125) {
                    this.theGame.fontRenderer.drawString(this.theResearch.get(0).getName(), var5 + 30, var6 + 18, -1);
                } else {
                    float vv = 125.0f / (float)offset;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(var5 + 30), (float)((float)(var6 + 16) + 2.0f / vv), (float)0.0f);
                    GL11.glScalef((float)vv, (float)vv, (float)vv);
                    this.theGame.fontRenderer.drawString(this.theResearch.get(0).getName(), 0, 0, -1);
                    GL11.glPopMatrix();
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
                RenderHelper.enableGUIStandardItemLighting();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glEnable((int)2896);
                if (this.theResearch.get((int)0).icon_item != null) {
                    this.itemRender.renderItemIntoGUI(Minecraft.getMinecraft().fontRenderer, Minecraft.getMinecraft().renderEngine, InventoryUtils.cycleItemStack(this.theResearch.get((int)0).icon_item), var5 + 8, var6 + 8);
                } else if (this.theResearch.get((int)0).icon_resource != null) {
                    Minecraft.getMinecraft().renderEngine.bindTexture(this.theResearch.get((int)0).icon_resource);
                    UtilsFX.drawTexturedQuadFull(var5 + 8, var6 + 8, this.zLevel);
                }
                GL11.glDisable((int)2896);
            }
        }
    }
}

