/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.container.ContainerArcaneWorkbench;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.tiles.TileArcaneWorkbench;

@SideOnly(value=Side.CLIENT)
public class GuiArcaneWorkbench
extends GuiContainer {
    private TileArcaneWorkbench tileEntity;
    private InventoryPlayer ip;
    private int[][] aspectLocs = new int[][]{{72, 21}, {24, 43}, {24, 102}, {72, 124}, {120, 102}, {120, 43}};
    ArrayList<Aspect> primals = Aspect.getPrimalAspects();

    public GuiArcaneWorkbench(InventoryPlayer par1InventoryPlayer, TileArcaneWorkbench e) {
        super((Container)new ContainerArcaneWorkbench(par1InventoryPlayer, e));
        this.tileEntity = e;
        this.ip = par1InventoryPlayer;
        this.ySize = 234;
        this.xSize = 190;
    }

    protected void drawGuiContainerForegroundLayer() {
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        UtilsFX.bindTexture("textures/gui/gui_arcaneworkbench.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        int var5 = (this.width - this.xSize) / 2;
        int var6 = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(var5, var6, 0, 0, this.xSize, this.ySize);
        GL11.glDisable((int)3042);
        ItemWandCasting wand = null;
        if (this.tileEntity.getStackInSlot(10) != null && this.tileEntity.getStackInSlot(10).getItem() instanceof ItemWandCasting) {
            wand = (ItemWandCasting)this.tileEntity.getStackInSlot(10).getItem();
        }
        AspectList cost = null;
        if (ThaumcraftCraftingManager.findMatchingArcaneRecipe(this.tileEntity, this.ip.player) != null) {
            cost = ThaumcraftCraftingManager.findMatchingArcaneRecipeAspects(this.tileEntity, this.ip.player);
            int count = 0;
            for (Aspect primal : this.primals) {
                float amt = cost.getAmount(primal);
                if (cost.getAmount(primal) > 0) {
                    float alpha = 0.5f + (MathHelper.sin((float)((float)(this.ip.player.ticksExisted + count * 10) / 2.0f)) * 0.2f - 0.2f);
                    if (wand != null && (amt *= wand.getConsumptionModifier(this.tileEntity.getStackInSlot(10), this.ip.player, primal, true)) * 100.0f <= (float)wand.getVis(this.tileEntity.getStackInSlot(10), primal)) {
                        alpha = 1.0f;
                    }
                    UtilsFX.drawTag(var5 + this.aspectLocs[count][0] - 8, var6 + this.aspectLocs[count][1] - 8, primal, amt, 0, (double)this.zLevel, 771, alpha, false);
                }
                if (++count <= 5) continue;
                break;
            }
        }
        if (wand != null && cost != null && !wand.consumeAllVisCrafting(this.tileEntity.getStackInSlot(10), this.ip.player, cost, false)) {
            GL11.glPushMatrix();
            float var40 = 0.33f;
            GL11.glColor4f((float)var40, (float)var40, (float)var40, (float)0.66f);
            GuiArcaneWorkbench.itemRender.renderWithColor = false;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3042);
            itemRender.renderItemAndEffectIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, ThaumcraftCraftingManager.findMatchingArcaneRecipe(this.tileEntity, this.ip.player), var5 + 160, var6 + 64);
            itemRender.renderItemOverlayIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, ThaumcraftCraftingManager.findMatchingArcaneRecipe(this.tileEntity, this.ip.player), var5 + 160, var6 + 64);
            GuiArcaneWorkbench.itemRender.renderWithColor = true;
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var5 + 168), (float)(var6 + 46), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
            String text = "Insufficient vis";
            int ll = this.fontRendererObj.getStringWidth(text) / 2;
            this.fontRendererObj.drawString(text, -ll, 0, 0xEE6E6E);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }
}

