/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.particles;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.common.config.ConfigBlocks;

public class FXSwarm
extends EntityFX {
    private Entity target;
    private float turnSpeed = 10.0f;
    private float speed = 0.2f;
    int deathtimer = 0;
    private static ArrayList<Long> buzzcount = new ArrayList();
    public int particle = 40;

    public FXSwarm(World par1World, double x, double y, double z, Entity target, float r, float g, float b) {
        super(par1World, x, y, z, 0.0, 0.0, 0.0);
        this.particleRed = r;
        this.particleGreen = g;
        this.particleBlue = b;
        this.particleScale = this.rand.nextFloat() * 0.5f + 1.0f;
        this.target = target;
        float f3 = 0.2f;
        this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * f3;
        this.motionY = (this.rand.nextFloat() - this.rand.nextFloat()) * f3;
        this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * f3;
        this.particleGravity = 0.1f;
        this.noClip = false;
        EntityLivingBase renderentity = FMLClientHandler.instance().getClient().renderViewEntity;
        int visibleDistance = 64;
        if (!FMLClientHandler.instance().getClient().gameSettings.fancyGraphics) {
            visibleDistance = 32;
        }
        if (renderentity.getDistance(this.posX, this.posY, this.posZ) > (double)visibleDistance) {
            this.particleMaxAge = 0;
        }
    }

    public FXSwarm(World par1World, double x, double y, double z, Entity target, float r, float g, float b, float sp, float ts, float pg) {
        this(par1World, x, y, z, target, r, g, b);
        this.speed = sp;
        this.turnSpeed = ts;
        this.particleGravity = pg;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float bob = MathHelper.sin((float)((float)this.particleAge / 3.0f)) * 0.25f + 1.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        int part = 7 + this.particleAge % 8;
        float var8 = (float)part / 16.0f;
        float var9 = var8 + 0.0624375f;
        float var10 = 0.25f;
        float var11 = var10 + 0.0624375f;
        float var12 = 0.1f * this.particleScale * bob;
        float var13 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float var14 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float var15 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        float var16 = 1.0f;
        float trans = (50.0f - (float)this.deathtimer) / 50.0f;
        tessellator.setBrightness(240);
        if (this.target instanceof EntityLivingBase && ((EntityLivingBase)this.target).hurtTime <= 0) {
            tessellator.setColorRGBA_F(this.particleRed * var16, this.particleGreen * var16, this.particleBlue * var16, trans);
        } else {
            tessellator.setColorRGBA_F(this.particleRed * var16, this.particleGreen * var16 / 2.0f, this.particleBlue * var16 / 2.0f, trans);
        }
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 - f3 * var12 - f5 * var12), (double)var9, (double)var11);
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 - f3 * var12 + f5 * var12), (double)var9, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 + f3 * var12 + f5 * var12), (double)var8, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 + f3 * var12 - f5 * var12), (double)var8, (double)var11);
    }

    public int getFXLayer() {
        return 1;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.particleAge;
        if (this.target == null || this.target.isDead || this.target instanceof EntityLivingBase && ((EntityLivingBase)this.target).deathTime > 0) {
            ++this.deathtimer;
            this.motionY -= (double)(this.particleGravity / 2.0f);
            if (this.deathtimer > 50) {
                this.setDead();
            }
        } else {
            this.motionY += (double)this.particleGravity;
        }
        this.pushOutOfBlocks(this.posX, this.posY, this.posZ);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= 0.985;
        this.motionY *= 0.985;
        this.motionZ *= 0.985;
        if (!(this.target == null || this.target.isDead || this.target instanceof EntityLivingBase && ((EntityLivingBase)this.target).deathTime > 0)) {
            boolean hurt = false;
            if (this.target instanceof EntityLivingBase) {
                boolean bl = hurt = ((EntityLivingBase)this.target).hurtTime > 0;
            }
            if (this.getDistanceSqToEntity(this.target) > (double)this.target.width && !hurt) {
                this.faceEntity(this.target, this.turnSpeed / 2.0f + (float)this.rand.nextInt((int)(this.turnSpeed / 2.0f)), this.turnSpeed / 2.0f + (float)this.rand.nextInt((int)(this.turnSpeed / 2.0f)));
            } else {
                this.faceEntity(this.target, -(this.turnSpeed / 2.0f + (float)this.rand.nextInt((int)(this.turnSpeed / 2.0f))), -(this.turnSpeed / 2.0f + (float)this.rand.nextInt((int)(this.turnSpeed / 2.0f))));
            }
            this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
            this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
            this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
            this.setHeading(this.motionX, this.motionY, this.motionZ, this.speed, 15.0f);
        }
        if (buzzcount.size() < 3 && this.rand.nextInt(50) == 0 && this.worldObj.getClosestPlayerToEntity((Entity)this, 8.0) != null) {
            this.worldObj.playSound(this.posX, this.posY, this.posZ, "thaumcraft:fly", 0.03f, 0.5f + this.rand.nextFloat() * 0.4f, false);
            buzzcount.add(System.nanoTime() + 1500000L);
        }
        if (buzzcount.size() >= 3 && buzzcount.get(0) < System.nanoTime()) {
            buzzcount.remove(0);
        }
    }

    public void faceEntity(Entity par1Entity, float par2, float par3) {
        double d0 = par1Entity.posX - this.posX;
        double d1 = par1Entity.posZ - this.posZ;
        double d2 = (par1Entity.boundingBox.minY + par1Entity.boundingBox.maxY) / 2.0 - (this.boundingBox.minY + this.boundingBox.maxY) / 2.0;
        double d3 = MathHelper.sqrt_double((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.rotationPitch = this.updateRotation(this.rotationPitch, f3, par3);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f2, par2);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.wrapAngleTo180_float((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public void setHeading(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.sqrt_double((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)f2;
        par3 /= (double)f2;
        par5 /= (double)f2;
        par1 += this.rand.nextGaussian() * (double)(this.rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        par3 += this.rand.nextGaussian() * (double)(this.rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        par5 += this.rand.nextGaussian() * (double)(this.rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        this.motionX = par1 *= (double)par7;
        this.motionY = par3 *= (double)par7;
        this.motionZ = par5 *= (double)par7;
    }

    protected boolean pushOutOfBlocks(double par1, double par3, double par5) {
        int var7 = MathHelper.floor_double((double)par1);
        int var8 = MathHelper.floor_double((double)par3);
        int var9 = MathHelper.floor_double((double)par5);
        double var10 = par1 - (double)var7;
        double var12 = par3 - (double)var8;
        double var14 = par5 - (double)var9;
        if (this.worldObj.getBlock(var7, var8, var9) != ConfigBlocks.blockTaintFibres && !this.worldObj.isAirBlock(var7, var8, var9) && !this.worldObj.isAnyLiquid(this.boundingBox)) {
            boolean var16 = !this.worldObj.isBlockNormalCubeDefault(var7 - 1, var8, var9, true);
            boolean var17 = !this.worldObj.isBlockNormalCubeDefault(var7 + 1, var8, var9, true);
            boolean var18 = !this.worldObj.isBlockNormalCubeDefault(var7, var8 - 1, var9, true);
            boolean var19 = !this.worldObj.isBlockNormalCubeDefault(var7, var8 + 1, var9, true);
            boolean var20 = !this.worldObj.isBlockNormalCubeDefault(var7, var8, var9 - 1, true);
            boolean var21 = !this.worldObj.isBlockNormalCubeDefault(var7, var8, var9 + 1, true);
            int var22 = -1;
            double var23 = 9999.0;
            if (var16 && var10 < var23) {
                var23 = var10;
                var22 = 0;
            }
            if (var17 && 1.0 - var10 < var23) {
                var23 = 1.0 - var10;
                var22 = 1;
            }
            if (var18 && var12 < var23) {
                var23 = var12;
                var22 = 2;
            }
            if (var19 && 1.0 - var12 < var23) {
                var23 = 1.0 - var12;
                var22 = 3;
            }
            if (var20 && var14 < var23) {
                var23 = var14;
                var22 = 4;
            }
            if (var21 && 1.0 - var14 < var23) {
                var23 = 1.0 - var14;
                var22 = 5;
            }
            float var25 = this.rand.nextFloat() * 0.05f + 0.025f;
            float var26 = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f;
            if (var22 == 0) {
                this.motionX = -var25;
                this.motionY = this.motionZ = (double)var26;
            }
            if (var22 == 1) {
                this.motionX = var25;
                this.motionY = this.motionZ = (double)var26;
            }
            if (var22 == 2) {
                this.motionY = -var25;
                this.motionX = this.motionZ = (double)var26;
            }
            if (var22 == 3) {
                this.motionY = var25;
                this.motionX = this.motionZ = (double)var26;
            }
            if (var22 == 4) {
                this.motionZ = -var25;
                this.motionY = this.motionX = (double)var26;
            }
            if (var22 == 5) {
                this.motionZ = var25;
                this.motionY = this.motionX = (double)var26;
            }
            return true;
        }
        return false;
    }
}

