/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.particles;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FXSmokeSpiral
extends EntityFX {
    private float radius = 1.0f;
    private int start = 0;
    private int miny = 0;

    public FXSmokeSpiral(World world, double d, double d1, double d2, float radius, int start, int miny) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.particleGravity = -0.01f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.particleScale *= 1.0f;
        this.particleMaxAge = 20 + world.rand.nextInt(10);
        this.noClip = false;
        this.setSize(0.01f, 0.01f);
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.radius = radius;
        this.start = start;
        this.miny = miny;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.66f * this.particleAlpha));
        int particle = (int)(1.0f + (float)this.particleAge / (float)this.particleMaxAge * 4.0f);
        float r1 = (float)this.start + 720.0f * (((float)this.particleAge + f) / (float)this.particleMaxAge);
        float r2 = 90.0f - 180.0f * (((float)this.particleAge + f) / (float)this.particleMaxAge);
        float mX = -MathHelper.sin((float)(r1 / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(r2 / 180.0f * (float)Math.PI));
        float mZ = MathHelper.cos((float)(r1 / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(r2 / 180.0f * (float)Math.PI));
        float mY = -MathHelper.sin((float)(r2 / 180.0f * (float)Math.PI));
        mX *= this.radius;
        mY *= this.radius;
        mZ *= this.radius;
        float var8 = (float)(particle % 16) / 16.0f;
        float var9 = var8 + 0.0624375f;
        float var10 = (float)(particle / 16) / 16.0f;
        float var11 = var10 + 0.0624375f;
        float var12 = 0.15f * this.particleScale;
        float var13 = (float)(this.posX + (double)mX - interpPosX);
        float var14 = (float)(Math.max(this.posY + (double)mY, (double)((float)this.miny + 0.1f)) - interpPosY);
        float var15 = (float)(this.posZ + (double)mZ - interpPosZ);
        float var16 = 1.0f;
        tessellator.setBrightness(this.getBrightnessForRender(f));
        tessellator.setColorRGBA_F(this.particleRed * var16, this.particleGreen * var16, this.particleBlue * var16, 0.66f * this.particleAlpha);
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 - f3 * var12 - f5 * var12), (double)var9, (double)var11);
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 - f3 * var12 + f5 * var12), (double)var9, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 + f3 * var12 + f5 * var12), (double)var8, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 + f3 * var12 - f5 * var12), (double)var8, (double)var11);
    }

    public int getFXLayer() {
        return 1;
    }

    public void onUpdate() {
        this.setAlphaF((float)(this.particleMaxAge - this.particleAge) / (float)this.particleMaxAge);
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
    }

    protected boolean pushOutOfBlocks(double par1, double par3, double par5) {
        int var7 = MathHelper.floor_double((double)par1);
        int var8 = MathHelper.floor_double((double)par3);
        int var9 = MathHelper.floor_double((double)par5);
        double var10 = par1 - (double)var7;
        double var12 = par3 - (double)var8;
        double var14 = par5 - (double)var9;
        if (!this.worldObj.isAirBlock(var7, var8, var9)) {
            boolean var16 = !this.worldObj.isBlockNormalCubeDefault(var7 - 1, var8, var9, true);
            boolean var17 = !this.worldObj.isBlockNormalCubeDefault(var7 + 1, var8, var9, true);
            boolean var18 = !this.worldObj.isBlockNormalCubeDefault(var7, var8 - 1, var9, true);
            boolean var19 = !this.worldObj.isBlockNormalCubeDefault(var7, var8 + 1, var9, true);
            boolean var20 = !this.worldObj.isBlockNormalCubeDefault(var7, var8, var9 - 1, true);
            boolean var21 = !this.worldObj.isBlockNormalCubeDefault(var7, var8, var9 + 1, true);
            int var22 = -1;
            double var23 = 9999.0;
            if (var16 && var10 < var23) {
                var23 = var10;
                var22 = 0;
            }
            if (var17 && 1.0 - var10 < var23) {
                var23 = 1.0 - var10;
                var22 = 1;
            }
            if (var18 && var12 < var23) {
                var23 = var12;
                var22 = 2;
            }
            if (var19 && 1.0 - var12 < var23) {
                var23 = 1.0 - var12;
                var22 = 3;
            }
            if (var20 && var14 < var23) {
                var23 = var14;
                var22 = 4;
            }
            if (var21 && 1.0 - var14 < var23) {
                var23 = 1.0 - var14;
                var22 = 5;
            }
            float var25 = this.rand.nextFloat() * 0.05f + 0.025f;
            float var26 = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f;
            if (var22 == 0) {
                this.motionX = -var25;
                this.motionY = this.motionZ = (double)var26;
            }
            if (var22 == 1) {
                this.motionX = var25;
                this.motionY = this.motionZ = (double)var26;
            }
            if (var22 == 2) {
                this.motionY = -var25;
                this.motionX = this.motionZ = (double)var26;
            }
            if (var22 == 3) {
                this.motionY = var25;
                this.motionX = this.motionZ = (double)var26;
            }
            if (var22 == 4) {
                this.motionZ = -var25;
                this.motionY = this.motionX = (double)var26;
            }
            if (var22 == 5) {
                this.motionZ = var25;
                this.motionY = this.motionX = (double)var26;
            }
            return true;
        }
        return false;
    }
}

