/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.particles;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class FXScorch
extends EntityFX {
    public boolean pvp = true;
    public boolean mobs = true;
    public boolean animals = true;
    private double px;
    private double py;
    private double pz;
    private float transferParticleScale;
    Entity partDestEnt;
    public boolean lance = false;

    public FXScorch(World world, double x, double y, double z, Vec3 v, float spread, boolean lance) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.lance = lance;
        this.px = x + v.xCoord * 100.0;
        this.py = y + v.yCoord * 100.0;
        this.pz = z + v.zCoord * 100.0;
        if (!lance) {
            this.px += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * spread);
            this.py += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * spread);
            this.pz += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * spread);
        } else {
            this.px += (double)(this.rand.nextFloat() - this.rand.nextFloat()) * 0.5;
            this.py += (double)(this.rand.nextFloat() - this.rand.nextFloat()) * 0.5;
            this.pz += (double)(this.rand.nextFloat() - this.rand.nextFloat()) * 0.5;
        }
        this.transferParticleScale = this.particleScale = this.rand.nextFloat() * 0.5f + 2.0f;
        if (!lance) {
            this.transferParticleScale = this.particleScale = this.rand.nextFloat() + 3.0f;
        }
        this.particleMaxAge = 50;
        this.setSize(0.1f, 0.1f);
        this.setParticleTextureIndex(151);
        this.noClip = false;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.particleAlpha = 0.66f;
    }

    public int getBrightnessForRender(float par1) {
        return 210;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    public void onUpdate() {
        float fs;
        double dx = this.px - this.posX;
        double dy = this.py - this.posY;
        double dz = this.pz - this.posZ;
        double distance = MathHelper.sqrt_double((double)(dx * dx + dy * dy + dz * dz));
        this.motionX = dx /= distance * 1.25;
        this.motionY = dy /= distance * 1.25;
        this.motionZ = dz /= distance * 1.25;
        this.motionX *= (double)((float)(this.particleMaxAge - this.particleAge) / (float)this.particleMaxAge);
        this.motionY *= (double)((float)(this.particleMaxAge - this.particleAge) / (float)this.particleMaxAge);
        this.motionZ *= (double)((float)(this.particleMaxAge - this.particleAge) / (float)this.particleMaxAge);
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionX += (double)(this.rand.nextFloat() * 0.07f - 0.035f);
        this.motionY += (double)(this.rand.nextFloat() * 0.07f - 0.035f);
        this.motionZ += (double)(this.rand.nextFloat() * 0.07f - 0.035f);
        int var7 = MathHelper.floor_double((double)this.posX);
        int var8 = MathHelper.floor_double((double)this.posY);
        int var9 = MathHelper.floor_double((double)this.posZ);
        if (this.particleAge > 1 && this.worldObj.getBlock(var7, var8, var9).isOpaqueCube()) {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.particleAge += 10;
        }
        this.func_145771_j(this.posX, (this.boundingBox.minY + this.boundingBox.maxY) / 2.0, this.posZ);
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        ++this.particleAge;
        if (this.particleAge >= this.particleMaxAge) {
            this.setDead();
        }
        if ((fs = (float)this.particleAge / (float)(this.particleMaxAge - 9)) <= 1.0f) {
            this.setParticleTextureIndex((int)(151.0f + fs * 6.0f));
        } else {
            this.setParticleTextureIndex(159 - (this.particleMaxAge - this.particleAge) / 3);
        }
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float fs = (float)this.particleAge / (float)this.particleMaxAge;
        this.particleScale = this.transferParticleScale * (fs + 0.25f) * 2.0f;
        float fc = (float)this.particleAge * 9.0f / (float)this.particleMaxAge;
        if (fc > 1.0f) {
            fc = 1.0f;
        }
        this.particleRed = this.particleGreen = fc;
        this.particleBlue = 1.0f;
        super.renderParticle(tessellator, f, f1, f2, f3, f4, f5);
    }
}

