/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.particles;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FXBlockRunes
extends EntityFX {
    double ofx = 0.0;
    double ofy = 0.0;
    float rotation = 0.0f;
    int runeIndex = 0;

    public FXBlockRunes(World world, double d, double d1, double d2, float f1, float f2, float f3, int m) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        if (f1 == 0.0f) {
            f1 = 1.0f;
        }
        this.rotation = this.rand.nextInt(4) * 90;
        this.particleRed = f1;
        this.particleGreen = f2;
        this.particleBlue = f3;
        this.particleGravity = 0.0f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.particleMaxAge = 3 * m;
        this.noClip = false;
        this.setSize(0.01f, 0.01f);
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.noClip = true;
        this.runeIndex = (int)(Math.random() * 16.0 + 224.0);
        this.ofx = (double)this.rand.nextFloat() * 0.2;
        this.ofy = -0.3 + (double)this.rand.nextFloat() * 0.6;
        this.particleScale = (float)(1.0 + this.rand.nextGaussian() * (double)0.1f);
        this.particleAlpha = 0.0f;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        tessellator.draw();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.particleAlpha / 2.0f));
        float var13 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float var14 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float var15 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        GL11.glTranslated((double)var13, (double)var14, (double)var15);
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)this.ofx, (double)this.ofy, (double)-0.51);
        float var8 = (float)(this.runeIndex % 16) / 16.0f;
        float var9 = var8 + 0.0624375f;
        float var10 = 0.375f;
        float var11 = var10 + 0.0624375f;
        float var12 = 0.3f * this.particleScale;
        float var16 = 1.0f;
        tessellator.startDrawingQuads();
        tessellator.setBrightness(240);
        tessellator.setColorRGBA_F(this.particleRed * var16, this.particleGreen * var16, this.particleBlue * var16, this.particleAlpha / 2.0f);
        tessellator.addVertexWithUV(-0.5 * (double)var12, 0.5 * (double)var12, 0.0, (double)var9, (double)var11);
        tessellator.addVertexWithUV(0.5 * (double)var12, 0.5 * (double)var12, 0.0, (double)var9, (double)var10);
        tessellator.addVertexWithUV(0.5 * (double)var12, -0.5 * (double)var12, 0.0, (double)var8, (double)var10);
        tessellator.addVertexWithUV(-0.5 * (double)var12, -0.5 * (double)var12, 0.0, (double)var8, (double)var11);
        tessellator.draw();
        GL11.glPopMatrix();
        tessellator.startDrawingQuads();
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        float threshold = (float)this.particleMaxAge / 5.0f;
        this.particleAlpha = (float)this.particleAge <= threshold ? (float)this.particleAge / threshold : (float)(this.particleMaxAge - this.particleAge) / (float)this.particleMaxAge;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.motionY -= 0.04 * (double)this.particleGravity;
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
    }

    public void setGravity(float value) {
        this.particleGravity = value;
    }
}

