/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.other;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;

public class FXBlockWard
extends EntityFX {
    ForgeDirection side;
    int rotation = 0;
    float sx = 0.0f;
    float sy = 0.0f;
    float sz = 0.0f;

    public FXBlockWard(World world, double d, double d1, double d2, ForgeDirection side, float f, float f1, float f2) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.side = side;
        this.particleGravity = 0.0f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.particleMaxAge = 12 + this.rand.nextInt(5);
        this.noClip = false;
        this.setSize(0.01f, 0.01f);
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.noClip = true;
        this.particleScale = (float)(1.4 + this.rand.nextGaussian() * (double)0.3f);
        this.rotation = this.rand.nextInt(360);
        this.sx = MathHelper.clamp_float((float)(f - 0.6f + this.rand.nextFloat() * 0.2f), (float)-0.4f, (float)0.4f);
        this.sy = MathHelper.clamp_float((float)(f1 - 0.6f + this.rand.nextFloat() * 0.2f), (float)-0.4f, (float)0.4f);
        this.sz = MathHelper.clamp_float((float)(f2 - 0.6f + this.rand.nextFloat() * 0.2f), (float)-0.4f, (float)0.4f);
        if (side.offsetX != 0) {
            this.sx = 0.0f;
        }
        if (side.offsetY != 0) {
            this.sy = 0.0f;
        }
        if (side.offsetZ != 0) {
            this.sz = 0.0f;
        }
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        tessellator.draw();
        GL11.glPushMatrix();
        float fade = ((float)this.particleAge + f) / (float)this.particleMaxAge;
        int frame = Math.min(15, (int)(15.0f * fade));
        UtilsFX.bindTexture("textures/models/hemis" + frame + ".png");
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.particleAlpha / 2.0f));
        float var13 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float var14 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float var15 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        GL11.glTranslated((double)(var13 + this.sx), (double)(var14 + this.sy), (double)(var15 + this.sz));
        GL11.glRotatef((float)90.0f, (float)this.side.offsetY, (float)(-this.side.offsetX), (float)this.side.offsetZ);
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.side.offsetZ > 0) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.505f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        } else {
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.505f);
        }
        float var12 = this.particleScale;
        float var16 = 1.0f;
        tessellator.startDrawingQuads();
        tessellator.setBrightness(240);
        tessellator.setColorRGBA_F(this.particleRed * var16, this.particleGreen * var16, this.particleBlue * var16, this.particleAlpha / 2.0f);
        tessellator.addVertexWithUV(-0.5 * (double)var12, 0.5 * (double)var12, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(0.5 * (double)var12, 0.5 * (double)var12, 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV(0.5 * (double)var12, -0.5 * (double)var12, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(-0.5 * (double)var12, -0.5 * (double)var12, 0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        Minecraft.getMinecraft().renderEngine.bindTexture(UtilsFX.getParticleTexture());
        tessellator.startDrawingQuads();
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        float threshold = (float)this.particleMaxAge / 5.0f;
        this.particleAlpha = (float)this.particleAge <= threshold ? (float)this.particleAge / threshold : (float)(this.particleMaxAge - this.particleAge) / (float)this.particleMaxAge;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.motionY -= 0.04 * (double)this.particleGravity;
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
    }

    public void setGravity(float value) {
        this.particleGravity = value;
    }
}

