/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.beams;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.lib.UtilsFX;

public class FXBeamWand
extends EntityFX {
    public int particle = 16;
    EntityPlayer player = null;
    private double offset = 0.0;
    private float length = 0.0f;
    private float rotYaw = 0.0f;
    private float rotPitch = 0.0f;
    private float prevYaw = 0.0f;
    private float prevPitch = 0.0f;
    private Entity targetEntity = null;
    private double tX = 0.0;
    private double tY = 0.0;
    private double tZ = 0.0;
    private double ptX = 0.0;
    private double ptY = 0.0;
    private double ptZ = 0.0;
    private int type = 0;
    private float endMod = 1.0f;
    private boolean reverse = false;
    private boolean pulse = true;
    private int rotationspeed = 5;
    private float prevSize = 0.0f;
    public int impact;

    public FXBeamWand(World par1World, EntityPlayer player, double tx, double ty, double tz, float red, float green, float blue, int age) {
        super(par1World, player.posX, player.posY, player.posZ, 0.0, 0.0, 0.0);
        if (player.getEntityId() != Minecraft.getMinecraft().renderViewEntity.getEntityId()) {
            this.offset = (double)(player.height / 2.0f) + 0.25;
        }
        this.particleRed = red;
        this.particleGreen = green;
        this.particleBlue = blue;
        this.player = player;
        this.setSize(0.02f, 0.02f);
        this.noClip = true;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.tX = tx;
        this.tY = ty;
        this.tZ = tz;
        float xd = (float)(player.posX - this.tX);
        float yd = (float)(player.posY + this.offset - this.tY);
        float zd = (float)(player.posZ - this.tZ);
        this.length = MathHelper.sqrt_float((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.sqrt_double((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.particleMaxAge = age;
        EntityLivingBase renderentity = FMLClientHandler.instance().getClient().renderViewEntity;
        int visibleDistance = 50;
        if (!FMLClientHandler.instance().getClient().gameSettings.fancyGraphics) {
            visibleDistance = 25;
        }
        if (renderentity.getDistance(player.posX, player.posY, player.posZ) > (double)visibleDistance) {
            this.particleMaxAge = 0;
        }
    }

    public void updateBeam(double x, double y, double z) {
        this.tX = x;
        this.tY = y;
        this.tZ = z;
        while (this.particleMaxAge - this.particleAge < 4) {
            ++this.particleMaxAge;
        }
    }

    public void onUpdate() {
        this.prevPosX = this.player.posX;
        this.prevPosY = this.player.posY + this.offset;
        this.prevPosZ = this.player.posZ;
        this.ptX = this.tX;
        this.ptY = this.tY;
        this.ptZ = this.tZ;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        float xd = (float)(this.player.posX - this.tX);
        float yd = (float)(this.player.posY + this.offset - this.tY);
        float zd = (float)(this.player.posZ - this.tZ);
        this.length = MathHelper.sqrt_float((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.sqrt_double((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        while (this.rotPitch - this.prevPitch < -180.0f) {
            this.prevPitch -= 360.0f;
        }
        while (this.rotPitch - this.prevPitch >= 180.0f) {
            this.prevPitch += 360.0f;
        }
        while (this.rotYaw - this.prevYaw < -180.0f) {
            this.prevYaw -= 360.0f;
        }
        while (this.rotYaw - this.prevYaw >= 180.0f) {
            this.prevYaw += 360.0f;
        }
        if (this.impact > 0) {
            --this.impact;
        }
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
    }

    public void setRGB(float r, float g, float b) {
        this.particleRed = r;
        this.particleGreen = g;
        this.particleBlue = b;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setEndMod(float endMod) {
        this.endMod = endMod;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setPulse(boolean pulse) {
        this.pulse = pulse;
    }

    public void setRotationspeed(int rotationspeed) {
        this.rotationspeed = rotationspeed;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        tessellator.draw();
        GL11.glPushMatrix();
        float var9 = 1.0f;
        float slide = Minecraft.getMinecraft().thePlayer.ticksExisted;
        float rot = (float)(this.worldObj.provider.getWorldTime() % (long)(360 / this.rotationspeed) * (long)this.rotationspeed) + (float)this.rotationspeed * f;
        float size = 1.0f;
        if (this.pulse) {
            size = Math.min((float)this.particleAge / 4.0f, 1.0f);
            size = (float)((double)this.prevSize + (double)(size - this.prevSize) * (double)f);
        }
        float op = 0.4f;
        if (this.pulse && this.particleMaxAge - this.particleAge <= 4) {
            op = 0.4f - (float)(4 - (this.particleMaxAge - this.particleAge)) * 0.1f;
        }
        switch (this.type) {
            default: {
                UtilsFX.bindTexture("textures/misc/beam.png");
                break;
            }
            case 1: {
                UtilsFX.bindTexture("textures/misc/beam1.png");
                break;
            }
            case 2: {
                UtilsFX.bindTexture("textures/misc/beam2.png");
                break;
            }
            case 3: {
                UtilsFX.bindTexture("textures/misc/beam3.png");
            }
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2884);
        float var11 = slide + f;
        if (this.reverse) {
            var11 *= -1.0f;
        }
        float var12 = -var11 * 0.2f - (float)MathHelper.floor_float((float)(-var11 * 0.1f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        double prex = this.player.prevPosX;
        double prey = this.player.prevPosY + this.offset;
        double prez = this.player.prevPosZ;
        double px = this.player.posX;
        double py = this.player.posY + this.offset;
        double pz = this.player.posZ;
        prex -= (double)(MathHelper.cos((float)(this.player.prevRotationYaw / 180.0f * 3.141593f)) * 0.066f);
        prey -= 0.06;
        prez -= (double)(MathHelper.sin((float)(this.player.prevRotationYaw / 180.0f * 3.141593f)) * 0.04f);
        Vec3 vec3d = this.player.getLook(1.0f);
        prex += vec3d.xCoord * 0.3;
        prey += vec3d.yCoord * 0.3;
        prez += vec3d.zCoord * 0.3;
        px -= (double)(MathHelper.cos((float)(this.player.rotationYaw / 180.0f * 3.141593f)) * 0.066f);
        py -= 0.06;
        pz -= (double)(MathHelper.sin((float)(this.player.rotationYaw / 180.0f * 3.141593f)) * 0.04f);
        vec3d = this.player.getLook(1.0f);
        float xx = (float)(prex + ((px += vec3d.xCoord * 0.3) - prex) * (double)f - interpPosX);
        float yy = (float)(prey + ((py += vec3d.yCoord * 0.3) - prey) * (double)f - interpPosY);
        float zz = (float)(prez + ((pz += vec3d.zCoord * 0.3) - prez) * (double)f - interpPosZ);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float ry = (float)((double)this.prevYaw + (double)(this.rotYaw - this.prevYaw) * (double)f);
        float rp = (float)((double)this.prevPitch + (double)(this.rotPitch - this.prevPitch) * (double)f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + ry), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rp, (float)1.0f, (float)0.0f, (float)0.0f);
        double var44 = -0.15 * (double)size;
        double var17 = 0.15 * (double)size;
        double var44b = -0.15 * (double)size * (double)this.endMod;
        double var17b = 0.15 * (double)size * (double)this.endMod;
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        for (int t = 0; t < 3; ++t) {
            double var29 = this.length * size * var9;
            double var31 = 0.0;
            double var33 = 1.0;
            double var35 = -1.0f + var12 + (float)t / 3.0f;
            double var37 = (double)(this.length * size * var9) + var35;
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.startDrawingQuads();
            tessellator.setBrightness(200);
            tessellator.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, op);
            tessellator.addVertexWithUV(var44b, var29, 0.0, var33, var37);
            tessellator.addVertexWithUV(var44, 0.0, 0.0, var33, var35);
            tessellator.addVertexWithUV(var17, 0.0, 0.0, var31, var35);
            tessellator.addVertexWithUV(var17b, var29, 0.0, var31, var37);
            tessellator.draw();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        if (this.impact > 0) {
            this.renderImpact(tessellator, f, f1, f2, f3, f4, f5);
        }
        Minecraft.getMinecraft().renderEngine.bindTexture(UtilsFX.getParticleTexture());
        tessellator.startDrawingQuads();
        this.prevSize = size;
    }

    public void renderImpact(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        UtilsFX.bindTexture(ParticleEngine.particleTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.66f);
        int part = this.particleAge % 16;
        float var8 = (float)part / 16.0f;
        float var9 = var8 + 0.0624375f;
        float var10 = 0.3125f;
        float var11 = var10 + 0.0624375f;
        float var12 = this.endMod / 2.0f / (float)(6 - this.impact);
        float var13 = (float)(this.ptX + (this.tX - this.ptX) * (double)f - interpPosX);
        float var14 = (float)(this.ptY + (this.tY - this.ptY) * (double)f - interpPosY);
        float var15 = (float)(this.ptZ + (this.tZ - this.ptZ) * (double)f - interpPosZ);
        float var16 = 1.0f;
        tessellator.startDrawingQuads();
        tessellator.setBrightness(200);
        tessellator.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, 0.66f);
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 - f3 * var12 - f5 * var12), (double)var9, (double)var11);
        tessellator.addVertexWithUV((double)(var13 - f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 - f3 * var12 + f5 * var12), (double)var9, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 + f4 * var12), (double)(var14 + f2 * var12), (double)(var15 + f3 * var12 + f5 * var12), (double)var8, (double)var10);
        tessellator.addVertexWithUV((double)(var13 + f1 * var12 - f4 * var12), (double)(var14 - f2 * var12), (double)(var15 + f3 * var12 - f5 * var12), (double)var8, (double)var11);
        tessellator.draw();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }
}

