/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.beams;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;

public class FXBeam
extends EntityFX {
    public int particle = 16;
    boolean updated = false;
    double movX = 0.0;
    double movY = 0.0;
    double movZ = 0.0;
    private float length = 0.0f;
    private float rotYaw = 0.0f;
    private float rotPitch = 0.0f;
    private float prevYaw = 0.0f;
    private float prevPitch = 0.0f;
    private Entity targetEntity = null;
    private double tX = 0.0;
    private double tY = 0.0;
    private double tZ = 0.0;
    private int type = 0;
    private float endMod = 1.0f;
    private boolean reverse = false;
    private boolean pulse = true;
    private int rotationspeed = 5;
    private float prevSize = 0.0f;
    public int blendmode = 1;
    public float width = 1.0f;

    public FXBeam(World par1World, double x, double y, double z, double tx, double ty, double tz, float red, float green, float blue, int age) {
        super(par1World, x, y, z, 0.0, 0.0, 0.0);
        this.particleRed = red;
        this.particleGreen = green;
        this.particleBlue = blue;
        this.setSize(0.02f, 0.02f);
        this.noClip = true;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.tX = tx;
        this.tY = ty;
        this.tZ = tz;
        float xd = (float)(this.posX - this.tX);
        float yd = (float)(this.posY - this.tY);
        float zd = (float)(this.posZ - this.tZ);
        this.length = MathHelper.sqrt_float((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.sqrt_double((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.particleMaxAge = age;
        EntityLivingBase renderentity = FMLClientHandler.instance().getClient().renderViewEntity;
        int visibleDistance = 50;
        if (!FMLClientHandler.instance().getClient().gameSettings.fancyGraphics) {
            visibleDistance = 25;
        }
        if (renderentity.getDistance(this.posX, this.posY, this.posZ) > (double)visibleDistance) {
            this.particleMaxAge = 0;
        }
    }

    public FXBeam(World par1World, double x, double y, double z, Entity entity, float red, float green, float blue, int age) {
        super(par1World, x, y, z, 0.0, 0.0, 0.0);
        this.particleRed = red;
        this.particleGreen = green;
        this.particleBlue = blue;
        this.setSize(0.02f, 0.02f);
        this.noClip = true;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.targetEntity = entity;
        this.tX = this.targetEntity.posX;
        this.tY = this.targetEntity.posY + (double)this.targetEntity.getEyeHeight() - (double)(this.targetEntity.height / 2.0f);
        this.tZ = this.targetEntity.posZ;
        float xd = (float)(this.posX - this.tX);
        float yd = (float)(this.posY - this.tY);
        float zd = (float)(this.posZ - this.tZ);
        this.length = MathHelper.sqrt_float((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.sqrt_double((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.particleMaxAge = age;
        EntityLivingBase renderentity = FMLClientHandler.instance().getClient().renderViewEntity;
        int visibleDistance = 50;
        if (!FMLClientHandler.instance().getClient().gameSettings.fancyGraphics) {
            visibleDistance = 25;
        }
        if (renderentity.getDistance(this.posX, this.posY, this.posZ) > (double)visibleDistance) {
            this.particleMaxAge = 0;
        }
    }

    public void updateBeam(double xs, double ys, double zs, double x, double y, double z) {
        this.movX = xs;
        this.movY = ys;
        this.movZ = zs;
        this.tX = x;
        this.tY = y;
        this.tZ = z;
        while (this.particleMaxAge - this.particleAge < 4) {
            ++this.particleMaxAge;
        }
        this.updated = true;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.updated) {
            this.posX = this.movX;
            this.posY = this.movY;
            this.posZ = this.movZ;
            this.updated = false;
        }
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        if (this.targetEntity != null) {
            this.tX = this.targetEntity.posX;
            this.tY = this.targetEntity.posY + (double)this.targetEntity.getEyeHeight() - (double)(this.targetEntity.height / 2.0f);
            this.tZ = this.targetEntity.posZ;
        }
        float xd = (float)(this.posX - this.tX);
        float yd = (float)(this.posY - this.tY);
        float zd = (float)(this.posZ - this.tZ);
        this.length = MathHelper.sqrt_float((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.sqrt_double((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
    }

    public void setRGB(float r, float g, float b) {
        this.particleRed = r;
        this.particleGreen = g;
        this.particleBlue = b;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setEndMod(float endMod) {
        this.endMod = endMod;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setPulse(boolean pulse) {
        this.pulse = pulse;
    }

    public void setRotationspeed(int rotationspeed) {
        this.rotationspeed = rotationspeed;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        tessellator.draw();
        GL11.glPushMatrix();
        float var9 = 1.0f;
        float slide = Minecraft.getMinecraft().thePlayer.ticksExisted;
        float rot = (float)(this.worldObj.provider.getWorldTime() % (long)(360 / this.rotationspeed) * (long)this.rotationspeed) + (float)this.rotationspeed * f;
        float size = this.width;
        if (this.pulse) {
            size = Math.min((float)this.particleAge / 4.0f, this.width);
            size = (float)((double)this.prevSize + (double)(size - this.prevSize) * (double)f);
        }
        float op = 0.4f;
        if (this.pulse && this.particleMaxAge - this.particleAge <= 4) {
            op = 0.4f - (float)(4 - (this.particleMaxAge - this.particleAge)) * 0.1f;
        }
        switch (this.type) {
            default: {
                UtilsFX.bindTexture("textures/misc/beam.png");
                break;
            }
            case 1: {
                UtilsFX.bindTexture("textures/misc/beam1.png");
                break;
            }
            case 2: {
                UtilsFX.bindTexture("textures/misc/beam2.png");
                break;
            }
            case 3: {
                UtilsFX.bindTexture("textures/misc/beam3.png");
            }
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2884);
        float var11 = slide + f;
        if (this.reverse) {
            var11 *= -1.0f;
        }
        float var12 = -var11 * 0.2f - (float)MathHelper.floor_float((float)(-var11 * 0.1f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)this.blendmode);
        GL11.glDepthMask((boolean)false);
        float xx = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float yy = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float zz = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float ry = (float)((double)this.prevYaw + (double)(this.rotYaw - this.prevYaw) * (double)f);
        float rp = (float)((double)this.prevPitch + (double)(this.rotPitch - this.prevPitch) * (double)f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + ry), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rp, (float)1.0f, (float)0.0f, (float)0.0f);
        double var44 = -0.15 * (double)size;
        double var17 = 0.15 * (double)size;
        double var44b = -0.15 * (double)size * (double)this.endMod;
        double var17b = 0.15 * (double)size * (double)this.endMod;
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        for (int t = 0; t < 3; ++t) {
            double var29 = this.length * size / this.width * var9;
            double var31 = 0.0;
            double var33 = 1.0;
            double var35 = -1.0f + var12 + (float)t / 3.0f;
            double var37 = (double)(this.length * size / this.width * var9) + var35;
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.startDrawingQuads();
            tessellator.setBrightness(200);
            tessellator.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, op);
            tessellator.addVertexWithUV(var44b, var29, 0.0, var33, var37);
            tessellator.addVertexWithUV(var44, 0.0, 0.0, var33, var35);
            tessellator.addVertexWithUV(var17, 0.0, 0.0, var31, var35);
            tessellator.addVertexWithUV(var17b, var29, 0.0, var31, var37);
            tessellator.draw();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        Minecraft.getMinecraft().renderEngine.bindTexture(UtilsFX.getParticleTexture());
        tessellator.startDrawingQuads();
        this.prevSize = size;
    }
}

