/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.beams;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.lib.utils.Utils;

public class FXArc
extends EntityFX {
    public int particle = 16;
    ArrayList<Vec3> points = new ArrayList();
    private Entity targetEntity = null;
    private double tX = 0.0;
    private double tY = 0.0;
    private double tZ = 0.0;
    public int blendmode = 1;
    public float length = 1.0f;

    public FXArc(World par1World, double x, double y, double z, double tx, double ty, double tz, float red, float green, float blue, double hg) {
        super(par1World, x, y, z, 0.0, 0.0, 0.0);
        this.particleRed = red;
        this.particleGreen = green;
        this.particleBlue = blue;
        this.setSize(0.02f, 0.02f);
        this.noClip = true;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.tX = tx - x;
        this.tY = ty - y;
        this.tZ = tz - z;
        this.particleMaxAge = 1;
        double xx = 0.0;
        double yy = 0.0;
        double zz = 0.0;
        double gravity = 0.115;
        double noise = 0.25;
        Vec3 vs = Vec3.createVectorHelper((double)xx, (double)yy, (double)zz);
        Vec3 ve = Vec3.createVectorHelper((double)this.tX, (double)this.tY, (double)this.tZ);
        Vec3 vc = Vec3.createVectorHelper((double)xx, (double)yy, (double)zz);
        this.length = (float)ve.lengthVector();
        Vec3 vv = Utils.calculateVelocity(vs, ve, hg, gravity);
        double l = Utils.distanceSquared3d(Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0), vv);
        this.points.add(vs);
        for (int c = 0; Utils.distanceSquared3d(ve, vc) > l && c < 50; ++c) {
            Vec3 vt = vc.addVector(vv.xCoord, vv.yCoord, vv.zCoord);
            vc = Vec3.createVectorHelper((double)vt.xCoord, (double)vt.yCoord, (double)vt.zCoord);
            vt.xCoord += (this.rand.nextDouble() - this.rand.nextDouble()) * noise;
            vt.yCoord += (this.rand.nextDouble() - this.rand.nextDouble()) * noise;
            vt.zCoord += (this.rand.nextDouble() - this.rand.nextDouble()) * noise;
            this.points.add(vt);
            vv.yCoord -= gravity / 1.9;
        }
        this.points.add(ve);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
    }

    public void setRGB(float r, float g, float b) {
        this.particleRed = r;
        this.particleGreen = g;
        this.particleBlue = b;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        double dz;
        double dy;
        double dx;
        float f13;
        Vec3 v;
        int c;
        tessellator.draw();
        GL11.glPushMatrix();
        double ePX = this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX;
        double ePY = this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY;
        double ePZ = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ;
        GL11.glTranslated((double)ePX, (double)ePY, (double)ePZ);
        float size = 0.25f;
        UtilsFX.bindTexture("textures/misc/beamh.png");
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2884);
        tessellator.startDrawing(5);
        tessellator.setBrightness(200);
        tessellator.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, 0.8f);
        float f9 = 0.0f;
        float f10 = 1.0f;
        for (c = 0; c < this.points.size(); ++c) {
            v = this.points.get(c);
            f13 = (float)c / this.length;
            dx = v.xCoord;
            dy = v.yCoord;
            dz = v.zCoord;
            tessellator.addVertexWithUV(dx, dy - (double)size, dz, (double)f13, (double)f10);
            tessellator.addVertexWithUV(dx, dy + (double)size, dz, (double)f13, (double)f9);
        }
        tessellator.draw();
        tessellator.startDrawing(5);
        tessellator.setBrightness(200);
        tessellator.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, 0.8f);
        for (c = 0; c < this.points.size(); ++c) {
            v = this.points.get(c);
            f13 = (float)c / this.length;
            dx = v.xCoord;
            dy = v.yCoord;
            dz = v.zCoord;
            tessellator.addVertexWithUV(dx - (double)size, dy, dz - (double)size, (double)f13, (double)f10);
            tessellator.addVertexWithUV(dx + (double)size, dy, dz + (double)size, (double)f13, (double)f9);
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        Minecraft.getMinecraft().renderEngine.bindTexture(UtilsFX.getParticleTexture());
        tessellator.startDrawingQuads();
    }
}

