/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class ParticleEngine {
    public static ParticleEngine instance = new ParticleEngine();
    public static final ResourceLocation particleTexture = new ResourceLocation("thaumcraft", "textures/misc/particles.png");
    public static final ResourceLocation particleTexture2 = new ResourceLocation("thaumcraft", "textures/misc/particles2.png");
    protected World worldObj;
    private HashMap<Integer, ArrayList<EntityFX>>[] particles = new HashMap[]{new HashMap(), new HashMap(), new HashMap(), new HashMap()};
    private Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        float frame = event.partialTicks;
        EntityClientPlayerMP entity = Minecraft.getMinecraft().thePlayer;
        TextureManager renderer = Minecraft.getMinecraft().renderEngine;
        int dim = Minecraft.getMinecraft().theWorld.provider.dimensionId;
        renderer.bindTexture(particleTexture);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        boolean rebound = false;
        for (int layer = 0; layer < 4; ++layer) {
            ArrayList<EntityFX> parts;
            if (!this.particles[layer].containsKey(dim) || (parts = this.particles[layer].get(dim)).size() == 0) continue;
            if (!rebound && layer >= 2) {
                renderer.bindTexture(particleTexture2);
                rebound = true;
            }
            GL11.glPushMatrix();
            switch (layer) {
                case 0: 
                case 2: {
                    GL11.glBlendFunc((int)770, (int)1);
                    break;
                }
                case 1: 
                case 3: {
                    GL11.glBlendFunc((int)770, (int)771);
                }
            }
            float f1 = ActiveRenderInfo.rotationX;
            float f2 = ActiveRenderInfo.rotationZ;
            float f3 = ActiveRenderInfo.rotationYZ;
            float f4 = ActiveRenderInfo.rotationXY;
            float f5 = ActiveRenderInfo.rotationXZ;
            EntityFX.interpPosX = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)frame;
            EntityFX.interpPosY = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)frame;
            EntityFX.interpPosZ = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)frame;
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawingQuads();
            for (int j = 0; j < parts.size(); ++j) {
                final EntityFX entityfx = parts.get(j);
                if (entityfx == null) continue;
                tessellator.setBrightness(entityfx.getBrightnessForRender(frame));
                try {
                    entityfx.renderParticle(tessellator, frame, f1, f5, f2, f3, f4);
                    continue;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.makeCrashReport((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.makeCategory("Particle being rendered");
                    crashreportcategory.addCrashSectionCallable("Particle", new Callable(){

                        public String call() {
                            return entityfx.toString();
                        }
                    });
                    crashreportcategory.addCrashSectionCallable("Particle Type", new Callable(){

                        public String call() {
                            return "ENTITY_PARTICLE_TEXTURE";
                        }
                    });
                    throw new ReportedException(crashreport);
                }
            }
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
    }

    public void addEffect(World world, EntityFX fx) {
        ArrayList<EntityFX> parts;
        if (!this.particles[fx.getFXLayer()].containsKey(world.provider.dimensionId)) {
            this.particles[fx.getFXLayer()].put(world.provider.dimensionId, new ArrayList());
        }
        if ((parts = this.particles[fx.getFXLayer()].get(world.provider.dimensionId)).size() >= 2000) {
            parts.remove(0);
        }
        parts.add(fx);
        this.particles[fx.getFXLayer()].put(world.provider.dimensionId, parts);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void updateParticles(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient world = mc.theWorld;
        if (mc.theWorld == null) {
            return;
        }
        int dim = world.provider.dimensionId;
        if (event.phase == TickEvent.Phase.START) {
            for (int layer = 0; layer < 4; ++layer) {
                if (!this.particles[layer].containsKey(dim)) continue;
                ArrayList<EntityFX> parts = this.particles[layer].get(dim);
                for (int j = 0; j < parts.size(); ++j) {
                    final EntityFX entityfx = parts.get(j);
                    try {
                        if (entityfx != null) {
                            entityfx.onUpdate();
                        }
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.makeCrashReport((Throwable)throwable, (String)"Ticking Particle");
                        CrashReportCategory crashreportcategory = crashreport.makeCategory("Particle being ticked");
                        crashreportcategory.addCrashSectionCallable("Particle", new Callable(){

                            public String call() {
                                return entityfx.toString();
                            }
                        });
                        crashreportcategory.addCrashSectionCallable("Particle Type", new Callable(){

                            public String call() {
                                return "ENTITY_PARTICLE_TEXTURE";
                            }
                        });
                        throw new ReportedException(crashreport);
                    }
                    if (entityfx != null && !entityfx.isDead) continue;
                    parts.remove(j--);
                    this.particles[layer].put(dim, parts);
                }
            }
        }
    }
}

