/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.accessory.IHealthAccessory;

public class ArmorExtended
implements IInventory {
    public ItemStack[] inventory = new ItemStack[7];
    public WeakReference<EntityPlayer> parent;
    public UUID globalID = UUID.fromString("B243BE32-DC1B-4C53-8D13-8752D5C69D5B");
    private static int soulBoundID = -6;

    public void init(EntityPlayer player) {
        this.parent = new WeakReference<EntityPlayer>(player);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean isStackInSlot(int slot) {
        return this.inventory[slot] != null;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            EntityPlayer player = (EntityPlayer)this.parent.get();
            TPlayerStats stats = TPlayerStats.get(player);
            this.recalculateHealth(player, stats);
            return split;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        EntityPlayer player = (EntityPlayer)this.parent.get();
        TPlayerStats stats = TPlayerStats.get(player);
        this.recalculateHealth(player, stats);
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        TPlayerStats stats = TPlayerStats.get(player);
        this.recalculateHealth(player, stats);
    }

    public void recalculateHealth(EntityPlayer player, TPlayerStats stats) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.inventory[4] != null || this.inventory[5] != null || this.inventory[6] != null) {
            int bonusHP = 0;
            for (int i = 4; i < 7; ++i) {
                ItemStack stack = this.inventory[i];
                if (stack == null || !(stack.func_77973_b() instanceof IHealthAccessory)) continue;
                bonusHP += ((IHealthAccessory)stack.func_77973_b()).getHealthBoost(stack);
            }
            int prevHealth = stats.bonusHealth;
            stats.bonusHealth = bonusHP;
            int healthChange = bonusHP - prevHealth;
            if (healthChange != 0) {
                IAttributeInstance attributeinstance = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
                try {
                    attributeinstance.func_111124_b(attributeinstance.func_111127_a(this.globalID));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                attributeinstance.func_111121_a(new AttributeModifier(this.globalID, "tconstruct.heartCanister", (double)bonusHP, 0));
            }
        } else if (this.parent != null && this.parent.get() != null) {
            int bonusHP;
            int prevHealth = stats.bonusHealth;
            stats.bonusHealth = bonusHP = 0;
            int healthChange = bonusHP - prevHealth;
            if (healthChange != 0) {
                IAttributeInstance attributeinstance = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
                try {
                    attributeinstance.func_111124_b(attributeinstance.func_111127_a(this.globalID));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }

    public void saveToNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound invSlot = new NBTTagCompound();
            invSlot.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(invSlot);
            tagList.func_74742_a((NBTBase)invSlot);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
                if (itemstack == null) continue;
                this.inventory[j] = itemstack;
            }
        }
    }

    public static int getSoulBoundID() {
        if (soulBoundID == -6) {
            ArmorExtended.setSoulBoundID();
        }
        return soulBoundID;
    }

    private static void setSoulBoundID() {
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null || !ench.func_77320_a().equals("enchantment.enderio.soulBound")) continue;
            soulBoundID = ench.field_77352_x;
            return;
        }
        soulBoundID = -1;
    }

    public static boolean isSoulBounded(ItemStack stack) {
        int soulBound = ArmorExtended.getSoulBoundID();
        NBTTagList stackEnch = stack.func_77986_q();
        if (soulBound >= 0 && stackEnch != null) {
            for (int i = 0; i < stackEnch.func_74745_c(); ++i) {
                int id = stackEnch.func_150305_b(i).func_74762_e("id");
                if (id != soulBound) continue;
                return true;
            }
        }
        return false;
    }

    public void dropItems() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        for (int i = 0; i < 4; ++i) {
            if (this.inventory[i] == null || ArmorExtended.isSoulBounded(this.inventory[i])) continue;
            player.func_146097_a(this.inventory[i], true, false);
            this.inventory[i] = null;
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void writeInventoryToStream(ByteBuf os) throws IOException {
        for (int i = 0; i < this.inventory.length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)os, (ItemStack)this.inventory[i]);
        }
    }

    public void readInventoryFromStream(ByteBuf is) throws IOException {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = ByteBufUtils.readItemStack((ByteBuf)is);
        }
    }
}

