/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.inventory.IInventoryAdapter;
import com.jaquadro.minecraft.storagedrawers.api.inventory.SlotType;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BaseDrawerData
implements IDrawer,
IInventoryAdapter {
    protected InventoryStack inventoryStack = new DrawerInventoryStack();
    private List<ItemStack> oreDictMatches;
    private Map<String, Object> auxData;

    protected BaseDrawerData() {
    }

    protected void postInit() {
        this.inventoryStack.init();
    }

    protected void reset() {
        this.oreDictMatches = null;
        this.inventoryStack.reset();
    }

    @Override
    public ItemStack getStoredItemCopy() {
        ItemStack protoStack = this.getStoredItemPrototype();
        if (protoStack == null) {
            return null;
        }
        ItemStack stack = protoStack.copy();
        stack.stackSize = this.getStoredItemCount();
        return stack;
    }

    protected void refreshOreDictMatches() {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)this.getStoredItemPrototype());
        if (oreIDs.length == 0) {
            this.oreDictMatches = null;
        } else {
            this.oreDictMatches = new ArrayList<ItemStack>();
            for (int id : oreIDs) {
                String oreName = OreDictionary.getOreName((int)id);
                if (!StorageDrawers.oreDictRegistry.isEntryValid(oreName)) continue;
                ArrayList list = OreDictionary.getOres((String)oreName);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (((ItemStack)list.get(i)).getItemDamage() == Short.MAX_VALUE) continue;
                    this.oreDictMatches.add((ItemStack)list.get(i));
                }
            }
            if (this.oreDictMatches.size() == 0) {
                this.oreDictMatches = null;
            }
        }
    }

    @Override
    public ItemStack getInventoryStack(SlotType slotType) {
        switch (slotType) {
            case INPUT: {
                return this.inventoryStack.getInStack();
            }
            case OUTPUT: {
                return this.inventoryStack.getOutStack();
            }
        }
        return null;
    }

    @Override
    public void setInStack(ItemStack stack) {
        this.inventoryStack.setInStack(stack);
    }

    @Override
    public void setOutStack(ItemStack stack) {
        this.inventoryStack.setOutStack(stack);
    }

    @Override
    public void syncInventory() {
        this.inventoryStack.markDirty();
    }

    @Override
    public boolean syncInventoryIfNeeded() {
        return this.inventoryStack.markDirtyIfNeeded();
    }

    @Override
    public Object getExtendedData(String key) {
        if (this.auxData == null || !this.auxData.containsKey(key)) {
            return null;
        }
        return this.auxData.get(key);
    }

    @Override
    public void setExtendedData(String key, Object data) {
        if (this.auxData == null) {
            this.auxData = new HashMap<String, Object>();
        }
        this.auxData.put(key, data);
    }

    protected int getItemCapacityForInventoryStack() {
        return this.getMaxCapacity();
    }

    public boolean areItemsEqual(ItemStack item) {
        ItemStack protoStack = this.getStoredItemPrototype();
        if (protoStack == null || item == null) {
            return false;
        }
        if (protoStack.getItem() == null || item.getItem() == null) {
            return false;
        }
        if (!protoStack.isItemEqual(item)) {
            if (!StorageDrawers.config.cache.enableItemConversion) {
                return false;
            }
            if (this.oreDictMatches == null) {
                return false;
            }
            if (protoStack.getItem() == item.getItem()) {
                return false;
            }
            boolean oreMatch = false;
            int n = this.oreDictMatches.size();
            for (int i = 0; i < n; ++i) {
                if (!item.isItemEqual(this.oreDictMatches.get(i))) continue;
                oreMatch = true;
                break;
            }
            if (!oreMatch) {
                return false;
            }
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)protoStack, (ItemStack)item);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return BaseDrawerData.areItemsEqual(stack1, stack2, true);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2, boolean oreDictStrictMode) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.getItem() == null || stack2.getItem() == null) {
            return false;
        }
        if (!stack1.isItemEqual(stack2)) {
            if (!StorageDrawers.config.cache.enableItemConversion) {
                return false;
            }
            if (stack1.getItemDamage() == Short.MAX_VALUE || stack2.getItemDamage() == Short.MAX_VALUE) {
                return false;
            }
            if (stack1.getItem() == stack2.getItem()) {
                return false;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length == 0 || ids2.length == 0) {
                return false;
            }
            boolean oreMatch = false;
            for (int id1 : ids1) {
                for (int id2 : ids2) {
                    if (id1 != id2) continue;
                    String name = OreDictionary.getOreName((int)id1);
                    if (oreDictStrictMode && !StorageDrawers.oreDictRegistry.isEntryValid(name)) continue;
                    oreMatch = true;
                    break;
                }
                if (oreMatch) break;
            }
            if (!oreMatch) {
                return false;
            }
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    class DrawerInventoryStack
    extends InventoryStack {
        DrawerInventoryStack() {
        }

        @Override
        protected ItemStack getNewItemStack() {
            return BaseDrawerData.this.getStoredItemCopy();
        }

        @Override
        protected int getItemStackSize() {
            return BaseDrawerData.this.getStoredItemStackSize();
        }

        @Override
        protected int getItemCount() {
            return BaseDrawerData.this.getStoredItemCount();
        }

        @Override
        protected int getItemCapacity() {
            return BaseDrawerData.this.getItemCapacityForInventoryStack();
        }

        @Override
        protected void applyDiff(int diff) {
            if (diff != 0) {
                BaseDrawerData.this.setStoredItemCount(BaseDrawerData.this.getStoredItemCount() + diff);
            }
        }
    }
}

