/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation;

import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.integration.RefinedRelocation;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.SortingBlockRegistry;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.TileSortingTrim;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockSortingTrim
extends BlockTrim
implements ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSort;

    public BlockSortingTrim(String name) {
        super(name);
        this.setCreativeTab(RefinedRelocation.tabStorageDrawers);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileSortingTrim();
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        if (side == 1) {
            return this.iconSort[meta];
        }
        return super.getIcon(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        super.registerBlockIcons(register);
        String[] subtex = BlockWood.field_150096_a;
        this.iconSort = new IIcon[subtex.length];
        for (int i = 0; i < subtex.length; ++i) {
            this.iconSort[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_sort");
        }
    }

    public static boolean upgradeToSorting(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        Block sortingBlock = SortingBlockRegistry.resolveSortingBlock(block);
        if (sortingBlock != null) {
            world.setBlock(x, y, z, sortingBlock, meta, 3);
        }
        return true;
    }
}

