/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomTrim;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityFramingRenderer
extends TileEntitySpecialRenderer {
    private RenderItem itemRenderer = new RenderItem(){

        public byte getMiniBlockCount(ItemStack stack, byte original) {
            return 1;
        }

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };

    public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float partialTickTime) {
        TileEntityFramingTable tileTable = (TileEntityFramingTable)tile;
        if (tileTable == null) {
            return;
        }
        int meta = tile.getBlockMetadata();
        if ((meta & 8) != 0) {
            return;
        }
        this.itemRenderer.setRenderManager(RenderManager.instance);
        ItemStack target = tileTable.getStackInSlot(0);
        if (target != null) {
            Block block = Block.getBlockFromItem((Item)target.getItem());
            if (block instanceof BlockDrawersCustom) {
                ItemStack result = ItemCustomDrawers.makeItemStack(block, 1, tileTable.getStackInSlot(1), tileTable.getStackInSlot(2), tileTable.getStackInSlot(3));
                this.renderSlot(tileTable, x, y, z, result, 2.0f, 0.0f, 0.25f, 0.0f);
            } else if (block instanceof BlockTrimCustom) {
                ItemStack result = ItemCustomTrim.makeItemStack(block, 1, tileTable.getStackInSlot(1), tileTable.getStackInSlot(2));
                this.renderSlot(tileTable, x, y, z, result, 2.0f, 0.0f, 0.25f, 0.0f);
            }
        }
        this.renderSlot(tileTable, x, y, z, tileTable.getStackInSlot(1), 1.15f, -0.225f, 0.15f, 0.65f);
        this.renderSlot(tileTable, x, y, z, tileTable.getStackInSlot(2), 1.15f, -0.225f, 0.15f, -0.65f);
        this.renderSlot(tileTable, x, y, z, tileTable.getStackInSlot(3), 1.15f, 0.225f, 0.15f, 0.65f);
    }

    private void renderSlot(TileEntityFramingTable tileTable, double x, double y, double z, ItemStack item, float scale, float tx, float ty, float tz) {
        if (item == null) {
            return;
        }
        Block itemBlock = Block.getBlockFromItem((Item)item.getItem());
        if (itemBlock == null) {
            return;
        }
        int meta = tileTable.getBlockMetadata();
        int side = meta & 7;
        itemBlock.setBlockBoundsBasedOnState((IBlockAccess)tileTable.getWorldObj(), 0, 0, 0);
        itemBlock.setBlockBoundsForItemRender();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
        if (side == 2) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (side == 3) {
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (side == 4) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glTranslatef((float)tx, (float)ty, (float)tz);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        try {
            EntityItem itemEnt = new EntityItem(null, 0.0, 0.0, 0.0, item);
            itemEnt.hoverStart = 0.0f;
            this.itemRenderer.doRender(itemEnt, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glPopMatrix();
    }
}

