/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.ModularBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelperState;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class DrawersRenderer
implements ISimpleBlockRenderingHandler {
    private static final double unit = 0.0625;
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();
    private static final int[] cut = new int[]{59, 55, 47, 31};
    private static final float[][] drawerXYWH1 = new float[][]{{0.0f, 0.0f, 16.0f, 16.0f}};
    private static final float[][] drawerXYWH2 = new float[][]{{0.0f, 8.0f, 16.0f, 8.0f}, {0.0f, 0.0f, 16.0f, 8.0f}};
    private static final float[][] drawerXYWH4 = new float[][]{{0.0f, 8.0f, 8.0f, 8.0f}, {0.0f, 0.0f, 8.0f, 8.0f}, {8.0f, 8.0f, 8.0f, 8.0f}, {8.0f, 0.0f, 8.0f, 8.0f}};
    private static final float[][] drawerXYWH3 = new float[][]{{0.0f, 8.0f, 16.0f, 8.0f}, {0.0f, 0.0f, 8.0f, 8.0f}, {8.0f, 0.0f, 8.0f, 8.0f}};

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockDrawers)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockDrawers)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockDrawers block, int modelId, RenderBlocks renderer) {
        TileEntityDrawers tile = block.getTileEntity(world, x, y, z);
        if (tile == null) {
            return false;
        }
        this.renderBaseBlock(world, tile, x, y, z, block, renderer);
        if (renderer.overrideBlockTexture != null && renderer.overrideBlockTexture.getIconName().startsWith("destroy_stage")) {
            return true;
        }
        int side = tile.getDirection();
        if (StorageDrawers.config.cache.enableIndicatorUpgrades) {
            this.renderIndicator(block, x, y, z, side, renderer, tile.getEffectiveStatusLevel());
        }
        if (StorageDrawers.config.cache.enableLockUpgrades) {
            this.renderLock(block, x, y, z, side, renderer, tile.isLocked(LockAttribute.LOCK_POPULATED), tile.getOwner() != null);
        }
        if (StorageDrawers.config.cache.enableVoidUpgrades) {
            this.renderVoid(block, x, y, z, side, renderer, tile.isVoid());
        }
        if (StorageDrawers.config.cache.enableTape) {
            this.renderTape(block, x, y, z, side, renderer, tile.isSealed());
        }
        this.renderShroud(block, x, y, z, side, renderer, tile.isShrouded());
        return true;
    }

    protected void renderBaseBlock(IBlockAccess world, TileEntityDrawers tile, int x, int y, int z, BlockDrawers block, RenderBlocks renderer) {
        int side = tile.getDirection();
        int meta = world.getBlockMetadata(x, y, z);
        RenderHelper.instance.state.setUVRotation(1, RenderHelperState.ROTATION_BY_FACE_FACE[2][side]);
        this.boxRenderer.setUnit(block.getTrimWidth());
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setExteriorIcon(block.getIcon(world, x, y, z, i), i);
        }
        this.boxRenderer.setCutIcon(block.getIconTrim(meta));
        this.boxRenderer.setInteriorIcon(block.getIconTrim(meta));
        this.renderExterior(block, x, y, z, side, renderer);
        RenderHelper.instance.state.clearUVRotation(1);
        int maxStorageLevel = tile.getMaxStorageLevel();
        if (maxStorageLevel > 1 && StorageDrawers.config.cache.renderStorageUpgrades && !tile.shouldHideUpgrades()) {
            for (int i = 0; i < 6; ++i) {
                this.boxRenderer.setExteriorIcon(block.getOverlayIcon(world, x, y, z, i, maxStorageLevel), i);
            }
            this.boxRenderer.setCutIcon(block.getOverlayIconTrim(maxStorageLevel));
            this.boxRenderer.setInteriorIcon(block.getOverlayIconTrim(maxStorageLevel));
            this.renderExterior(block, x, y, z, side, renderer);
        }
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.getIcon(world, x, y, z, side), ForgeDirection.OPPOSITES[side]);
        this.renderInterior(block, x, y, z, side, renderer);
    }

    private void renderLock(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, boolean locked, boolean owned) {
        if (!locked && !owned) {
            return;
        }
        double depth = block.halfDepth ? 0.5 : 1.0;
        IIcon iconLock = block.getLockIcon(locked, owned);
        RenderHelper.instance.setRenderBounds(0.46875, 0.9375, 0.0, 0.53125, 1.0, depth + 0.005);
        RenderHelper.instance.state.setRotateTransform(3, side);
        RenderHelper.instance.renderPartialFace(3, renderer.blockAccess, (Block)block, x, y, z, iconLock, 0.0, 0.0, 1.0, 1.0);
        RenderHelper.instance.state.clearRotateTransform();
    }

    private void renderVoid(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, boolean voided) {
        if (!voided) {
            return;
        }
        double depth = block.halfDepth ? 0.5 : 1.0;
        IIcon iconVoid = block.getVoidIcon();
        RenderHelper.instance.setRenderBounds(0.9375, 0.9375, 0.0, 1.0, 1.0, depth + 0.005);
        RenderHelper.instance.state.setRotateTransform(3, side);
        RenderHelper.instance.renderPartialFace(3, renderer.blockAccess, (Block)block, x, y, z, iconVoid, 0.0, 0.0, 1.0, 1.0);
        RenderHelper.instance.state.clearRotateTransform();
    }

    private void renderTape(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, boolean taped) {
        if (!taped) {
            return;
        }
        double depth = block.halfDepth ? 0.5 : 1.0;
        IIcon iconTape = block.getTapeIcon();
        RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, depth + 0.005);
        RenderHelper.instance.state.setRotateTransform(3, side);
        RenderHelper.instance.renderFace(3, renderer.blockAccess, (Block)block, x, y, z, iconTape);
        RenderHelper.instance.state.clearRotateTransform();
    }

    private void renderShroud(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, boolean shrouded) {
        if (!shrouded || side < 2 || side > 5) {
            return;
        }
        TileEntityDrawers tile = block.getTileEntity(renderer.blockAccess, x, y, z);
        double depth = block.halfDepth ? 8.0 : 16.0;
        double depthAdj = block.getTrimDepth() * 16.0f;
        int count = 0;
        float w = 2.0f;
        float h = 2.0f;
        float[][] xywhSet = null;
        if (block.drawerCount == 1) {
            count = 1;
            w = 4.0f;
            h = 4.0f;
            xywhSet = drawerXYWH1;
        } else if (block.drawerCount == 2) {
            count = 2;
            xywhSet = drawerXYWH2;
        } else if (block.drawerCount == 3) {
            count = 3;
            xywhSet = drawerXYWH3;
        } else if (block.drawerCount == 4) {
            count = 4;
            xywhSet = drawerXYWH4;
        }
        IIcon icon = block.getIconTrim(renderer.blockAccess.getBlockMetadata(x, y, z));
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = tile.getDrawer(i);
            if (drawer == null || drawer.isEmpty()) continue;
            float[] xywh = xywhSet[i];
            float subX = xywh[0] + (xywh[2] - w) / 2.0f;
            float subY = xywh[1] + (xywh[3] - h) / 2.0f;
            RenderHelper.instance.setRenderBounds((double)subX * 0.0625, (double)subY * 0.0625, 0.0, (double)(subX + w) * 0.0625, (double)(subY + h) * 0.0625, (depth - depthAdj + 0.05) * 0.0625);
            RenderHelper.instance.state.setRotateTransform(3, side);
            RenderHelper.instance.renderFace(3, renderer.blockAccess, (Block)block, x, y, z, icon);
            RenderHelper.instance.state.clearRotateTransform();
        }
    }

    private void renderIndicator(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer, int level) {
        if (level <= 0 || side < 2 || side > 5) {
            return;
        }
        TileEntityDrawers tile = block.getTileEntity(renderer.blockAccess, x, y, z);
        double depth = block.halfDepth ? 8.0 : 16.0;
        double depthAdj = block.getTrimDepth() * 16.0f;
        int count = 0;
        float[][] xywhSet = null;
        if (block.drawerCount == 1) {
            count = 1;
            xywhSet = drawerXYWH1;
        } else if (block.drawerCount == 2) {
            count = 2;
            xywhSet = drawerXYWH2;
        } else if (block.drawerCount == 4) {
            count = 4;
            xywhSet = drawerXYWH4;
        }
        IIcon iconOff = block.getIndicatorIcon(count, false);
        IIcon iconOn = block.getIndicatorIcon(count, true);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < count; ++i) {
            double indYEnd;
            IDrawer drawer = tile.getDrawer(i);
            if (drawer == null) continue;
            float[] xywh = xywhSet[i];
            RenderHelper.instance.setRenderBounds((double)xywh[0] * 0.0625, (double)xywh[1] * 0.0625, 0.0, (double)(xywh[0] + xywh[2]) * 0.0625, (double)(xywh[1] + xywh[3]) * 0.0625, (depth - depthAdj + 0.05) * 0.0625);
            RenderHelper.instance.state.setRotateTransform(3, side);
            RenderHelper.instance.renderFace(3, renderer.blockAccess, (Block)block, x, y, z, iconOff);
            RenderHelper.instance.state.clearRotateTransform();
            if (level == 1 && drawer.getMaxCapacity() > 0 && drawer.getRemainingCapacity() == 0) {
                RenderHelper.instance.state.setColorMult(1.0f, 1.0f, 0.9f, 1.0f);
                RenderHelper.instance.setRenderBounds((double)xywh[0] * 0.0625, (double)xywh[1] * 0.0625, 0.0, (double)(xywh[0] + xywh[2]) * 0.0625, (double)(xywh[1] + xywh[3]) * 0.0625, (depth - depthAdj + 0.06) * 0.0625);
                RenderHelper.instance.state.setRotateTransform(3, side);
                RenderHelper.instance.renderFace(3, renderer.blockAccess, (Block)block, x, y, z, iconOn);
                RenderHelper.instance.state.clearRotateTransform();
                RenderHelper.instance.state.resetColorMult();
                continue;
            }
            if (level < 2) continue;
            double indXStart = (double)xywh[0] + (double)block.getIndStart() / 0.0625;
            double indXEnd = (double)xywh[0] + (double)block.getIndEnd() / 0.0625;
            double indXCur = block.getIndSteps() == 0 ? indXEnd : this.getIndEnd(block, tile, i, indXStart, (double)(block.getIndEnd() - block.getIndStart()) / 0.0625);
            double indYStart = xywh[1];
            double indYCur = indYEnd = (double)(xywh[1] + xywh[3]);
            if (!(indXCur > indXStart)) continue;
            RenderHelper.instance.state.setColorMult(1.0f, 1.0f, 0.9f, 1.0f);
            RenderHelper.instance.setRenderBounds(indXStart * 0.0625, indYStart * 0.0625, 0.0, indXCur * 0.0625, indYCur * 0.0625, (depth - depthAdj + 0.06) * 0.0625);
            RenderHelper.instance.state.setRotateTransform(3, side);
            RenderHelper.instance.renderFace(3, renderer.blockAccess, (Block)block, x, y, z, iconOn);
            RenderHelper.instance.state.clearRotateTransform();
            RenderHelper.instance.state.resetColorMult();
        }
    }

    private double getIndEnd(BlockDrawers block, TileEntityDrawers tile, int slot, double x, double w) {
        IDrawer drawer = tile.getDrawer(slot);
        if (drawer == null) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        int step = block.getIndSteps() > 0 ? block.getIndSteps() : 1000;
        float fillAmt = (float)((double)step * (double)count / (double)cap) / (float)step;
        return x + w * (double)fillAmt;
    }

    private void renderExterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 1.0 - depth;
                zMax = 1.0;
                break;
            }
            case 3: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 0.0;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0;
                zMin = 0.0;
                zMax = 1.0;
                break;
            }
            case 5: {
                xMin = 0.0;
                xMax = depth;
                zMin = 0.0;
                zMax = 1.0;
            }
        }
        this.boxRenderer.renderExterior(renderer.blockAccess, (Block)block, x, y, z, xMin, 0.0, zMin, xMax, 1.0, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    private void renderInterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double unit = block.getTrimDepth();
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = 1.0 - depth;
                zMax = 1.0 - depth + unit;
                break;
            }
            case 3: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = depth - unit;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0 - depth + unit;
                zMin = unit;
                zMax = 1.0 - unit;
                break;
            }
            case 5: {
                xMin = depth - unit;
                xMax = depth;
                zMin = unit;
                zMax = 1.0 - unit;
            }
        }
        this.boxRenderer.renderInterior(renderer.blockAccess, (Block)block, x, y, z, xMin, unit, zMin, xMax, 1.0 - unit, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return StorageDrawers.proxy.drawersRenderID;
    }
}

