/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.inventory.IDrawerInventory;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroupInteractive;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ILockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ISealable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseTileEntity;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.ISideManager;
import com.jaquadro.minecraft.storagedrawers.inventory.StorageInventory;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.IUpgradeProvider;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;

public abstract class TileEntityDrawers
extends BaseTileEntity
implements IDrawerGroupInteractive,
ISidedInventory,
IUpgradeProvider,
ILockable,
ISealable,
IProtectable {
    private IDrawer[] drawers;
    private IDrawerInventory inventory;
    private int[] autoSides = new int[]{0, 1, 2, 3, 4, 5};
    private int direction;
    private int drawerCapacity = 1;
    private boolean shrouded = false;
    private boolean taped = false;
    private boolean hideUpgrade = false;
    private UUID owner;
    private String securityKey;
    private EnumSet<LockAttribute> lockAttributes = null;
    private ItemStack[] upgrades = new ItemStack[5];
    private long lastClickTime;
    private UUID lastClickUUID;
    private String customName;
    private ItemStack materialSide;
    private ItemStack materialFront;
    private ItemStack materialTrim;

    protected TileEntityDrawers(int drawerCount) {
        this.initWithDrawerCount(drawerCount);
    }

    protected abstract IDrawer createDrawer(int var1);

    protected ISideManager getSideManager() {
        return new DefaultSideManager();
    }

    protected void initWithDrawerCount(int drawerCount) {
        this.drawers = new IDrawer[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.drawers[i] = this.createDrawer(i);
        }
        this.inventory = new StorageInventory(this, this.getSideManager(), this);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction % 6;
    }

    public int getMaxStorageLevel() {
        int maxLevel = 1;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.getItem() != ModItems.upgrade) continue;
            maxLevel = Math.max(maxLevel, upgrade.getItemDamage());
        }
        return maxLevel;
    }

    public int getEffectiveStorageLevel() {
        int level = 0;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.getItem() != ModItems.upgrade) continue;
            level += upgrade.getItemDamage();
        }
        return Math.max(level, 1);
    }

    public int getEffectiveStorageMultiplier() {
        ConfigManager config = StorageDrawers.config;
        int multiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.getItem() != ModItems.upgrade) continue;
            multiplier += config.getStorageUpgradeMultiplier(stack.getItemDamage());
        }
        if (multiplier == 0) {
            multiplier = config.getStorageUpgradeMultiplier(1);
        }
        return multiplier;
    }

    public int getEffectiveStatusLevel() {
        int maxLevel = 0;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.getItem() != ModItems.upgradeStatus) continue;
            maxLevel = upgrade.getItemDamage();
        }
        return maxLevel;
    }

    public int getUpgradeSlotCount() {
        return 5;
    }

    public ItemStack getUpgrade(int slot) {
        slot = MathHelper.clamp_int((int)slot, (int)0, (int)4);
        return this.upgrades[slot];
    }

    public boolean addUpgrade(ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public void setUpgrade(int slot, ItemStack upgrade) {
        slot = MathHelper.clamp_int((int)slot, (int)0, (int)4);
        if (upgrade != null) {
            upgrade = upgrade.copy();
            upgrade.stackSize = 1;
        }
        this.upgrades[slot] = upgrade;
        if (this.worldObj != null) {
            if (!this.worldObj.isRemote) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
        }
    }

    public int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int getDrawerCapacity() {
        return this.drawerCapacity;
    }

    public void setDrawerCapacity(int stackCount) {
        this.drawerCapacity = stackCount;
    }

    @Override
    public boolean isLocked(LockAttribute attr) {
        if (!StorageDrawers.config.cache.enableLockUpgrades || this.lockAttributes == null) {
            return false;
        }
        return this.lockAttributes.contains((Object)attr);
    }

    @Override
    public boolean canLock(LockAttribute attr) {
        return StorageDrawers.config.cache.enableLockUpgrades;
    }

    @Override
    public void setLocked(LockAttribute attr, boolean isLocked) {
        if (!StorageDrawers.config.cache.enableLockUpgrades) {
            return;
        }
        if (isLocked && (this.lockAttributes == null || !this.lockAttributes.contains((Object)attr))) {
            if (this.lockAttributes == null) {
                this.lockAttributes = EnumSet.of(attr);
            } else {
                this.lockAttributes.add(attr);
            }
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        } else if (!isLocked && this.lockAttributes != null && this.lockAttributes.contains((Object)attr)) {
            this.lockAttributes.remove((Object)attr);
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    @Override
    public boolean isShrouded() {
        if (!StorageDrawers.config.cache.enableShroudUpgrades) {
            return false;
        }
        return this.shrouded;
    }

    public void setIsShrouded(boolean shrouded) {
        if (this.shrouded != shrouded) {
            this.shrouded = shrouded;
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    @Override
    public UUID getOwner() {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return null;
        }
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
        return true;
    }

    @Override
    public ISecurityProvider getSecurityProvider() {
        return StorageDrawers.securityRegistry.getProvider(this.securityKey);
    }

    @Override
    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
        return true;
    }

    public boolean shouldHideUpgrades() {
        return this.hideUpgrade;
    }

    public void setShouldHideUpgrades(boolean hide) {
        this.hideUpgrade = hide;
        if (this.worldObj != null && !this.worldObj.isRemote) {
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public boolean isSealed() {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        return this.taped;
    }

    @Override
    public boolean setIsSealed(boolean state) {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        if (this.taped != state) {
            this.taped = state;
            if (this.worldObj != null && !this.worldObj.isRemote) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
        return true;
    }

    @Override
    public boolean isVoid() {
        if (!StorageDrawers.config.cache.enableVoidUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.getItem() != ModItems.upgradeVoid) continue;
            return true;
        }
        return false;
    }

    public boolean isUnlimited() {
        if (!StorageDrawers.config.cache.enableCreativeUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.getItem() != ModItems.upgradeCreative) continue;
            return true;
        }
        return false;
    }

    public boolean isVending() {
        if (!StorageDrawers.config.cache.enableCreativeUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.getItem() != ModItems.upgradeCreative || stack.getItemDamage() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isRedstone() {
        if (!StorageDrawers.config.cache.enableRedstoneUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.getItem() != ModItems.upgradeRedstone) continue;
            return true;
        }
        return false;
    }

    public int getRedstoneLevel() {
        int redstoneType = -1;
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.getItem() != ModItems.upgradeRedstone) continue;
            redstoneType = stack.getItemDamage();
            break;
        }
        switch (redstoneType) {
            case 0: {
                return this.getCombinedRedstoneLevel();
            }
            case 1: {
                return this.getMaxRedstoneLevel();
            }
            case 2: {
                return this.getMinRedstoneLevel();
            }
        }
        return 0;
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            if (!this.isDrawerEnabled(i)) continue;
            IDrawer drawer = this.getDrawer(i);
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            if (!this.isDrawerEnabled(i)) continue;
            IDrawer drawer = this.getDrawer(i);
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this.isDrawerEnabled(i) || (drawer = this.getDrawer(i)).getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @Override
    public boolean isSorting() {
        return false;
    }

    public ItemStack getMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getMaterialFront() {
        return this.materialFront;
    }

    public ItemStack getMaterialTrim() {
        return this.materialTrim;
    }

    public ItemStack getEffectiveMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getEffectiveMaterialFront() {
        return this.materialFront != null ? this.materialFront : this.materialSide;
    }

    public ItemStack getEffectiveMaterialTrim() {
        return this.materialTrim != null ? this.materialTrim : this.materialSide;
    }

    public void setMaterialSide(ItemStack material) {
        this.materialSide = material;
    }

    public void setMaterialFront(ItemStack material) {
        this.materialFront = material;
    }

    public void setMaterialTrim(ItemStack material) {
        this.materialTrim = material;
    }

    @Override
    public ItemStack takeItemsFromSlot(int slot, int count) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return null;
        }
        ItemStack stack = this.getItemsFromSlot(slot, count);
        if (stack == null) {
            return null;
        }
        IDrawer drawer = this.drawers[slot];
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.stackSize);
        if (this.isRedstone() && this.worldObj != null) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
        }
        return stack;
    }

    protected ItemStack getItemsFromSlot(int slot, int count) {
        if (this.drawers[slot].isEmpty()) {
            return null;
        }
        ItemStack stack = this.drawers[slot].getStoredItemCopy();
        stack.stackSize = Math.min(stack.getMaxStackSize(), count);
        stack.stackSize = Math.min(stack.stackSize, this.drawers[slot].getStoredItemCount());
        return stack;
    }

    @Override
    public int putItemsIntoSlot(int slot, ItemStack stack, int count) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return 0;
        }
        IDrawer drawer = this.drawers[slot];
        if (drawer.isEmpty()) {
            drawer.setStoredItem(stack, 0);
        }
        if (!drawer.canItemBeStored(stack)) {
            return 0;
        }
        int countAdded = Math.min(count, stack.stackSize);
        if (!this.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.stackSize -= countAdded;
        return countAdded;
    }

    @Override
    public int interactPutCurrentItemIntoSlot(int slot, EntityPlayer player) {
        int count = 0;
        ItemStack playerStack = player.inventory.getCurrentItem();
        if (playerStack != null) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.stackSize);
        }
        if (count > 0) {
            this.markDirty();
        }
        return count;
    }

    @Override
    public int interactPutCurrentInventoryIntoSlot(int slot, EntityPlayer player) {
        int count = 0;
        if (!this.drawers[slot].isEmpty()) {
            int n = player.inventory.getSizeInventory();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.inventory.getStackInSlot(i);
                if (subStack == null) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.stackSize);
                if (subCount > 0 && subStack.stackSize == 0) {
                    player.inventory.setInventorySlotContents(i, null);
                }
                count += subCount;
            }
        }
        if (count > 0) {
            StorageDrawers.proxy.updatePlayerInventory(player);
        }
        this.markDirty();
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, EntityPlayer player) {
        int count = 0;
        count = this.worldObj.getTotalWorldTime() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.worldObj.getTotalWorldTime();
        this.lastClickUUID = player.getPersistentID();
        return count;
    }

    private void readLegacyUpgradeNBT(NBTTagCompound tag) {
        if (tag.hasKey("Lev") && tag.getByte("Lev") > 1) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgrade, 1, (int)tag.getByte("Lev")));
        }
        if (tag.hasKey("Stat")) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeStatus, 1, (int)tag.getByte("Stat")));
        }
        if (tag.hasKey("Void")) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeVoid));
        }
    }

    @Override
    protected void readFromFixedNBT(NBTTagCompound tag) {
        super.readFromFixedNBT(tag);
        this.setDirection(tag.getByte("Dir"));
        this.taped = false;
        if (tag.hasKey("Tape")) {
            this.taped = tag.getBoolean("Tape");
        }
        this.customName = null;
        if (tag.hasKey("CustomName", 8)) {
            this.customName = tag.getString("CustomName");
        }
    }

    @Override
    protected void writeToFixedNBT(NBTTagCompound tag) {
        super.writeToFixedNBT(tag);
        tag.setByte("Dir", (byte)this.direction);
        if (this.taped) {
            tag.setBoolean("Tape", this.taped);
        }
        if (this.hasCustomInventoryName()) {
            tag.setString("CustomName", this.customName);
        }
    }

    @Override
    public void readFromPortableNBT(NBTTagCompound tag) {
        int i;
        super.readFromPortableNBT(tag);
        this.upgrades = new ItemStack[this.upgrades.length];
        this.drawerCapacity = tag.getInteger("Cap");
        if (!tag.hasKey("Upgrades")) {
            this.readLegacyUpgradeNBT(tag);
        } else {
            NBTTagList upgradeList = tag.getTagList("Upgrades", 10);
            for (i = 0; i < upgradeList.tagCount(); ++i) {
                NBTTagCompound upgradeTag = upgradeList.getCompoundTagAt(i);
                byte slot = upgradeTag.getByte("Slot");
                this.setUpgrade(slot, ItemStack.loadItemStackFromNBT((NBTTagCompound)upgradeTag));
            }
        }
        this.lockAttributes = null;
        if (tag.hasKey("Lock")) {
            this.lockAttributes = LockAttribute.getEnumSet(tag.getByte("Lock"));
        }
        this.shrouded = false;
        if (tag.hasKey("Shr")) {
            this.shrouded = tag.getBoolean("Shr");
        }
        this.owner = null;
        if (tag.hasKey("Own")) {
            this.owner = UUID.fromString(tag.getString("Own"));
        }
        this.securityKey = null;
        if (tag.hasKey("Sec")) {
            this.securityKey = tag.getString("Sec");
        }
        this.hideUpgrade = false;
        if (tag.hasKey("HideUp")) {
            this.hideUpgrade = tag.getBoolean("HideUp");
        }
        NBTTagList slots = tag.getTagList("Slots", 10);
        this.drawers = new IDrawer[slots.tagCount()];
        int n = this.drawers.length;
        for (i = 0; i < n; ++i) {
            NBTTagCompound slot = slots.getCompoundTagAt(i);
            this.drawers[i] = this.createDrawer(i);
            this.drawers[i].readFromNBT(slot);
        }
        this.inventory = new StorageInventory(this, this.getSideManager(), this);
        this.materialSide = null;
        if (tag.hasKey("MatS")) {
            this.materialSide = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatS"));
        }
        this.materialFront = null;
        if (tag.hasKey("MatF")) {
            this.materialFront = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatF"));
        }
        this.materialTrim = null;
        if (tag.hasKey("MatT")) {
            this.materialTrim = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatT"));
        }
    }

    @Override
    public void writeToPortableNBT(NBTTagCompound tag) {
        NBTTagCompound itag;
        super.writeToPortableNBT(tag);
        tag.setInteger("Cap", this.drawerCapacity);
        NBTTagList upgradeList = new NBTTagList();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] == null) continue;
            IDrawer[] upgradeTag = this.upgrades[i].writeToNBT(new NBTTagCompound());
            upgradeTag.setByte("Slot", (byte)i);
            upgradeList.appendTag((NBTBase)upgradeTag);
        }
        if (upgradeList.tagCount() > 0) {
            tag.setTag("Upgrades", (NBTBase)upgradeList);
        }
        if (this.lockAttributes != null) {
            tag.setByte("Lock", (byte)LockAttribute.getBitfield(this.lockAttributes));
        }
        if (this.shrouded) {
            tag.setBoolean("Shr", this.shrouded);
        }
        if (this.owner != null) {
            tag.setString("Own", this.owner.toString());
        }
        if (this.securityKey != null) {
            tag.setString("Sec", this.securityKey);
        }
        if (this.hideUpgrade) {
            tag.setBoolean("HideUp", this.hideUpgrade);
        }
        NBTTagList slots = new NBTTagList();
        for (IDrawer drawer : this.drawers) {
            NBTTagCompound slot = new NBTTagCompound();
            drawer.writeToNBT(slot);
            slots.appendTag((NBTBase)slot);
        }
        tag.setTag("Slots", (NBTBase)slots);
        if (this.materialSide != null) {
            itag = new NBTTagCompound();
            this.materialSide.writeToNBT(itag);
            tag.setTag("MatS", (NBTBase)itag);
        }
        if (this.materialFront != null) {
            itag = new NBTTagCompound();
            this.materialFront.writeToNBT(itag);
            tag.setTag("MatF", (NBTBase)itag);
        }
        if (this.materialTrim != null) {
            itag = new NBTTagCompound();
            this.materialTrim.writeToNBT(itag);
            tag.setTag("MatT", (NBTBase)itag);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void markDirty() {
        this.inventory.markDirty();
        if (this.isRedstone() && this.worldObj != null) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType());
        }
        super.markDirty();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        if (this.inventory.syncInventoryIfNeeded()) {
            super.markDirty();
            return true;
        }
        return false;
    }

    public void clientUpdateCount(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
            switch (this.getEffectiveStatusLevel()) {
                case 1: {
                    if (drawer.getStoredItemCount() != 0 && drawer.getRemainingCapacity() != 0) break;
                    this.getWorldObj().func_147479_m(this.xCoord, this.yCoord, this.zCoord);
                    break;
                }
                case 2: {
                    this.getWorldObj().func_147479_m(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }
    }

    private void syncClientCount(int slot) {
        CountUpdateMessage message = new CountUpdateMessage(this.xCoord, this.yCoord, this.zCoord, slot, this.drawers[slot].getStoredItemCount());
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 500.0);
        StorageDrawers.network.sendToAllAround((IMessage)message, targetPoint);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
        this.getWorldObj().func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public int getDrawerCount() {
        return this.drawers.length;
    }

    @Override
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.drawers.length) {
            return null;
        }
        return this.drawers[slot];
    }

    @Override
    public IDrawerInventory getDrawerInventory() {
        return this.inventory;
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        if (this.isSealed()) {
            return false;
        }
        if (this.getBlockType() instanceof BlockDrawersCustom && this.materialSide == null) {
            return false;
        }
        return this.getDrawer(slot) != null;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return this.inventory.getAccessibleSlotsFromSide(side);
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        IDrawer drawer;
        if (this.isSealed()) {
            return false;
        }
        if (this.isLocked(LockAttribute.LOCK_EMPTY) && this.inventory instanceof StorageInventory && (drawer = this.getDrawer(this.inventory.getDrawerSlot(slot))) != null && drawer.isEmpty()) {
            return false;
        }
        return this.inventory.canInsertItem(slot, stack, side);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (this.isSealed()) {
            return false;
        }
        return this.inventory.canExtractItem(slot, stack, side);
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int count) {
        return this.inventory.decrStackSize(slot, count);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inventory.getStackInSlotOnClosing(slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inventory.setInventorySlotContents(slot, stack);
    }

    public void setInventoryName(String name) {
        this.customName = name;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "storageDrawers.container.drawers";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int getInventoryStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
        this.inventory.openInventory();
    }

    public void closeInventory() {
        this.inventory.closeInventory();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.inventory.isItemValidForSlot(slot, stack);
    }

    private class DefaultSideManager
    implements ISideManager {
        private DefaultSideManager() {
        }

        @Override
        public int[] getSlotsForSide(int side) {
            return TileEntityDrawers.this.autoSides;
        }
    }
}

