/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.core.ClientProxy;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockFramingTable
extends BlockContainer {
    public static final int[][] leftOffset = new int[][]{{0, 0}, {0, 0}, {1, 0}, {-1, 0}, {0, -1}, {0, 1}};
    public static final int[][] rightOffset = new int[][]{{0, 0}, {0, 0}, {-1, 0}, {1, 0}, {0, 1}, {0, -1}};
    private Random random = new Random();
    @SideOnly(value=Side.CLIENT)
    IIcon iconBase;
    @SideOnly(value=Side.CLIENT)
    IIcon iconTrim;
    @SideOnly(value=Side.CLIENT)
    IIcon iconOverlayLeft;
    @SideOnly(value=Side.CLIENT)
    IIcon iconOverlayRight;

    public BlockFramingTable(String blockName) {
        super(Material.wood);
        this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
        this.setHardness(2.5f);
        this.setStepSound(soundTypeWood);
        this.setBlockName(blockName);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityFramingTable();
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        int priZ;
        int meta = world.getBlockMetadata(x, y, z);
        int priX = x + this.getXOff(meta);
        if (world.getBlock(priX, y, priZ = z + this.getZOff(meta)) != this || (world.getBlockMetadata(priX, y, priZ) & 8) != 0) {
            return false;
        }
        player.openGui((Object)StorageDrawers.instance, GuiHandler.framingGuiID, world, priX, y, priZ);
        return true;
    }

    private int getXOff(int meta) {
        if (BlockFramingTable.isRightBlock(meta)) {
            return 0;
        }
        return rightOffset[BlockFramingTable.getDirection(meta)][0];
    }

    private int getZOff(int meta) {
        if (BlockFramingTable.isRightBlock(meta)) {
            return 0;
        }
        return rightOffset[BlockFramingTable.getDirection(meta)][1];
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return StorageDrawers.proxy.framingTableRenderID;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ClientProxy.renderPass = pass;
        return true;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int meta = world.getBlockMetadata(x, y, z);
        int side = BlockFramingTable.getDirection(meta);
        if (BlockFramingTable.isRightBlock(meta)) {
            if (world.getBlock(x + leftOffset[side][0], y, z + leftOffset[side][1]) != this) {
                world.setBlockToAir(x, y, z);
                if (!world.isRemote) {
                    this.dropBlockAsItem(world, x, y, z, 1, 0);
                }
            }
        } else if (world.getBlock(x + rightOffset[side][0], y, z + rightOffset[side][1]) != this) {
            world.setBlockToAir(x, y, z);
        }
    }

    public Item getItemDropped(int meta, Random random, int fortune) {
        return BlockFramingTable.isPrimaryBlock(meta) ? Item.getItemFromBlock((Block)ModBlocks.framingTable) : Item.getItemById((int)0);
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int meta, float chance, int fortune) {
        if (BlockFramingTable.isPrimaryBlock(meta)) {
            super.dropBlockAsItemWithChance(world, x, y, z, meta, chance, fortune);
        }
    }

    public int getMobilityFlag() {
        return 1;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        int side;
        if (player.capabilities.isCreativeMode && !BlockFramingTable.isPrimaryBlock(meta) && world.getBlock(x += rightOffset[side = BlockFramingTable.getDirection(meta)][0], y, z += rightOffset[side][1]) == this) {
            world.setBlockToAir(x, y, z);
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int side) {
        TileEntityFramingTable tile = (TileEntityFramingTable)world.getTileEntity(x, y, z);
        if (tile != null && BlockFramingTable.isPrimaryBlock(world.getBlockMetadata(x, y, z))) {
            int n = tile.getSizeInventory();
            for (int i = 0; i < n; ++i) {
                ItemStack stack = tile.getStackInSlot(i);
                if (stack == null) continue;
                float fx = this.random.nextFloat() * 0.8f + 0.1f;
                float fy = this.random.nextFloat() * 0.8f + 0.1f;
                float fz = this.random.nextFloat() * 0.8f + 0.1f;
                while (stack.stackSize > 0) {
                    int amount = this.random.nextInt(21) + 10;
                    if (amount > stack.stackSize) {
                        amount = stack.stackSize;
                    }
                    stack.stackSize -= amount;
                    EntityItem entity = new EntityItem(world, (double)((float)x + fx), (double)((float)y + fy), (double)((float)z + fz), new ItemStack(stack.getItem(), amount, stack.getItemDamage()));
                    if (stack.hasTagCompound()) {
                        entity.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
                    }
                    entity.motionX = this.random.nextGaussian() * (double)0.05f;
                    entity.motionY = this.random.nextGaussian() * (double)0.05f + (double)0.2f;
                    entity.motionZ = this.random.nextGaussian() * (double)0.05f;
                    world.spawnEntityInWorld((Entity)entity);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.breakBlock(world, x, y, z, block, side);
    }

    public static int getDirection(int meta) {
        return meta & 7;
    }

    public static boolean isRightBlock(int meta) {
        return (meta & 8) == 0;
    }

    public static boolean isPrimaryBlock(int meta) {
        return BlockFramingTable.isRightBlock(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconBase() {
        return this.iconBase;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim() {
        return this.iconTrim;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconOverlay(boolean left) {
        return left ? this.iconOverlayLeft : this.iconOverlayRight;
    }

    public void registerBlockIcons(IIconRegister register) {
        this.iconBase = register.registerIcon("StorageDrawers:base/base_oak");
        this.iconTrim = register.registerIcon("StorageDrawers:base/trim_oak");
        this.iconOverlayLeft = register.registerIcon("StorageDrawers:overlay/shading_worktable_left");
        this.iconOverlayRight = register.registerIcon("StorageDrawers:overlay/shading_worktable_right");
    }
}

