/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.IFluidBlock;

public class WorldGenQuarry
extends WorldGenerator {
    private static final int DISTANCE_OUTER_SQ = 64;
    private final Block blockStone;
    private final int meta;
    public final Set<Block> replaceable = new HashSet<Block>();

    public WorldGenQuarry(Block block, int meta) {
        this.blockStone = block;
        this.meta = meta;
        this.replaceable.add(Blocks.coal_ore);
        this.replaceable.add(Blocks.iron_ore);
        this.replaceable.add(Blocks.gold_ore);
        this.replaceable.add(Blocks.diamond_ore);
        this.replaceable.add(Blocks.emerald_ore);
        this.replaceable.add(Blocks.lapis_ore);
        this.replaceable.add(Blocks.quartz_ore);
        this.replaceable.add(Blocks.redstone_ore);
        this.replaceable.add(Blocks.lit_redstone_ore);
        this.replaceable.add(Blocks.dirt);
        this.replaceable.add(Blocks.gravel);
        this.replaceable.add((Block)Blocks.grass);
        this.replaceable.add(Blocks.clay);
        this.replaceable.addAll(OreDictPlugin.getOreBlocks());
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        int distSq;
        int j;
        int k;
        int i;
        boolean clearTop = true;
        for (i = -8; i < 8; ++i) {
            block1: for (k = -8; k < 8; ++k) {
                for (j = 1; j < 4 && j + y < world.getActualHeight() - 1; ++j) {
                    distSq = i * i + k * k;
                    if (distSq > 64 || !this.isLiquid(world, x + i, y + j, z + k)) continue;
                    clearTop = false;
                    continue block1;
                }
            }
        }
        if (clearTop) {
            for (i = -8; i < 8; ++i) {
                for (k = -8; k < 8; ++k) {
                    for (j = 1; j < 4 && j + y < world.getActualHeight() - 1 && ((distSq = i * i + k * k) > 64 || this.placeAir(world, rand, x + i, y + j, z + k)); ++j) {
                    }
                }
            }
        }
        for (i = -8; i < 8; ++i) {
            for (k = -8; k < 8; ++k) {
                for (j = -8; j < 1 && j + y < world.getActualHeight() - 1; ++j) {
                    distSq = i * i + k * k + j * j;
                    if (distSq > 64) continue;
                    this.placeStone(world, rand, x + i, y + j, z + k);
                }
            }
        }
        return true;
    }

    private boolean isLiquid(World world, int x, int y, int z) {
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        return block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    private boolean placeAir(World world, Random rand, int x, int y, int z) {
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z) != Blocks.air) {
            return false;
        }
        if (this.isLiquid(world, x, y, z)) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x + 1, y + 1, z) != Blocks.air) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x - 1, y + 1, z) != Blocks.air) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z + 1) != Blocks.air) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z - 1) != Blocks.air) {
            return false;
        }
        world.setBlock(x, y, z, Blocks.air, 0, 2);
        return true;
    }

    private void placeStone(World world, Random rand, int x, int y, int z) {
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z) == Blocks.tallgrass) {
            world.setBlock(x, y + 1, z, Blocks.air, 0, 2);
        }
        if (this.isReplaceable(world, x, y, z)) {
            world.setBlock(x, y, z, this.blockStone, this.meta, 2);
        }
    }

    private boolean isReplaceable(World world, int x, int y, int z) {
        Block existing = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        if (existing == null) {
            return false;
        }
        if (existing.isReplaceableOreGen(world, x, y, z, Blocks.stone)) {
            return true;
        }
        return this.replaceable.contains(existing);
    }
}

