/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Random;
import mods.railcraft.common.blocks.signals.ItemSignalBlockSurveyor;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemCrowbarReinforced;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemWhistleTuner;
import mods.railcraft.common.items.RailcraftToolItems;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class VillagerTradeHandler
implements VillagerRegistry.IVillageTradeHandler {
    private float baseChance;

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random rand) {
        this.baseChance = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"field_82191_bN"})).floatValue();
        this.addTrade(recipeList, rand, 0.7f, new Offer(Items.coal, 16, 24), new Offer(Items.emerald));
        this.addTrade(recipeList, rand, 0.7f, new Offer(Items.emerald), new Offer(Items.coal, 24, 32));
        this.addTrade(recipeList, rand, 0.4f, new Offer(RailcraftToolItems.getCoalCoke(), 8, 12), new Offer(Items.emerald));
        this.addTrade(recipeList, rand, 0.4f, new Offer(Items.emerald), new Offer(RailcraftToolItems.getCoalCoke(), 12, 16));
        this.addTrade(recipeList, rand, 0.7f, new Offer(Blocks.rail, 30, 34), new Offer(Items.emerald, 2, 3));
        this.addTrade(recipeList, rand, 0.1f, new Offer(Blocks.activator_rail, 14, 18), new Offer(Items.emerald, 2, 3));
        this.addTrade(recipeList, rand, 0.1f, new Offer(Blocks.golden_rail, 14, 18), new Offer(Items.emerald, 2, 3));
        this.addTrade(recipeList, rand, 0.1f, new Offer(Blocks.detector_rail, 14, 18), new Offer(Items.emerald, 2, 3));
        for (EnumTrack track : EnumTrack.VALUES) {
            if (!track.isEnabled()) continue;
            this.addTrade(recipeList, rand, 0.1f, new Offer(track.getItem(), track.recipeOutput - 2, track.recipeOutput + 2), new Offer(Items.emerald, 2, 3));
        }
        this.addTrade(recipeList, rand, 0.3f, new Offer(Items.minecart), new Offer(Items.emerald, 8, 10));
        this.addTrade(recipeList, rand, 0.3f, new Offer(Items.emerald, 6, 8), new Offer(Items.minecart));
        this.addTrade(recipeList, rand, 0.1f, new Offer(EnumCart.LOCO_STEAM_SOLID.getCartItem()), new Offer(Items.emerald, 32, 40));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemCrowbar.getItem()), new Offer(Items.emerald, 7, 9));
        this.addTrade(recipeList, rand, 0.1f, new Offer(ItemCrowbarReinforced.getItem()), new Offer(Items.emerald, 14, 18));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemWhistleTuner.getItem()), new Offer(Items.emerald, 1, 2));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemMagnifyingGlass.getItem()), new Offer(Items.emerald, 1, 2));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemSignalBlockSurveyor.getItem()), new Offer(Items.emerald, 6, 8));
        this.addTrade(recipeList, rand, 0.3f, new Offer(ItemSignalTuner.getItem()), new Offer(Items.emerald, 6, 8));
        this.addTrade(recipeList, rand, 0.4f, new Offer(ItemGoggles.getItem()), new Offer(Items.emerald, 4, 8));
        this.addTrade(recipeList, rand, 0.5f, new Offer(RailcraftToolItems.getOveralls()), new Offer(Items.emerald, 2, 4));
    }

    private void addTrade(MerchantRecipeList recipeList, Random rand, float chance, Offer sale, Offer ... offers) {
        if (offers.length <= 0 || sale.obj == null) {
            return;
        }
        for (Offer offer : offers) {
            if (offer.obj != null) continue;
            return;
        }
        if (rand.nextFloat() < this.adjustProbability(chance)) {
            ItemStack sellStack = this.prepareStack(rand, sale);
            ItemStack buyStack1 = this.prepareStack(rand, offers[0]);
            ItemStack buyStack2 = null;
            if (offers.length >= 2) {
                buyStack2 = this.prepareStack(rand, offers[1]);
            }
            recipeList.add((Object)new MerchantRecipe(buyStack1, buyStack2, sellStack));
        }
    }

    private ItemStack prepareStack(Random rand, Offer offer) throws IllegalArgumentException {
        if (offer.obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)offer.obj;
            stack.stackSize = this.stackSize(rand, offer.min, offer.max);
            return stack;
        }
        if (offer.obj instanceof Item) {
            return new ItemStack((Item)offer.obj, this.stackSize(rand, offer.min, offer.max));
        }
        if (offer.obj instanceof Block) {
            return new ItemStack((Block)offer.obj, this.stackSize(rand, offer.min, offer.max));
        }
        throw new IllegalArgumentException("Unrecongnized object passed to villager trade setup");
    }

    private int stackSize(Random rand, int min, int max) {
        return MathHelper.getRandomIntegerInRange((Random)rand, (int)min, (int)max);
    }

    private float adjustProbability(float chance) {
        float adjustedChance = chance + this.baseChance;
        return adjustedChance > 0.9f ? 0.9f - (adjustedChance - 0.9f) : adjustedChance;
    }

    private class Offer {
        public final Object obj;
        public final int min;
        public final int max;

        public Offer(Object obj, int min, int max) {
            this.obj = obj;
            this.min = min;
            this.max = max;
        }

        public Offer(Object obj, int amount) {
            this(obj, amount, amount);
        }

        public Offer(Object obj) {
            this(obj, 1);
        }
    }
}

