/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.sounds;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.post.BlockPost;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallBeta;
import net.minecraft.block.Block;

public class SoundRegistry {
    private static final Map<Block, Map<Integer, Block.SoundType>> customSounds = new HashMap<Block, Map<Integer, Block.SoundType>>();

    public static Block.SoundType getSound(Block block, int meta) {
        Map<Integer, Block.SoundType> blockSounds = customSounds.get(block);
        if (blockSounds != null) {
            return blockSounds.get(meta);
        }
        return null;
    }

    public static void setupBlockSounds() {
        Object block = BlockPost.block;
        if (block != null) {
            SoundRegistry.registerCustomStepSound(block, EnumPost.WOOD.ordinal(), Block.soundTypeWood);
            SoundRegistry.registerCustomStepSound(block, EnumPost.STONE.ordinal(), Block.soundTypeStone);
            SoundRegistry.registerCustomStepSound(block, EnumPost.METAL_UNPAINTED.ordinal(), Block.soundTypeMetal);
            SoundRegistry.registerCustomStepSound(block, EnumPost.WOOD_PLATFORM.ordinal(), Block.soundTypeWood);
            SoundRegistry.registerCustomStepSound(block, EnumPost.STONE_PLATFORM.ordinal(), Block.soundTypeStone);
            SoundRegistry.registerCustomStepSound(block, EnumPost.METAL_PLATFORM_UNPAINTED.ordinal(), Block.soundTypeMetal);
        }
        if ((block = BlockCube.getBlock()) != null) {
            for (Enum enum_ : EnumCube.VALUES) {
                SoundRegistry.registerCustomStepSound(block, enum_.ordinal(), Block.soundTypeStone);
            }
            SoundRegistry.registerCustomStepSound(block, EnumCube.STEEL_BLOCK.ordinal(), Block.soundTypeMetal);
            SoundRegistry.registerCustomStepSound(block, EnumCube.CRUSHED_OBSIDIAN.ordinal(), Block.soundTypeGravel);
            SoundRegistry.registerCustomStepSound(block, EnumCube.CREOSOTE_BLOCK.ordinal(), Block.soundTypeWood);
        }
        if ((block = BlockRailcraftWall.getBlockAlpha()) != null) {
            for (Enum enum_ : EnumWallAlpha.VALUES) {
                SoundRegistry.registerCustomStepSound(block, enum_.ordinal(), Block.soundTypeStone);
            }
            SoundRegistry.registerCustomStepSound(block, EnumWallAlpha.ICE.ordinal(), Block.soundTypeGlass);
            SoundRegistry.registerCustomStepSound(block, EnumWallAlpha.SNOW.ordinal(), Block.soundTypeSnow);
        }
        if ((block = BlockRailcraftWall.getBlockBeta()) != null) {
            for (Enum enum_ : EnumWallBeta.VALUES) {
                SoundRegistry.registerCustomStepSound(block, enum_.ordinal(), Block.soundTypeStone);
            }
        }
    }

    private static void registerCustomStepSound(Block block, int metadata, Block.SoundType sound) {
        Map<Integer, Block.SoundType> blockSounds = customSounds.get(block);
        if (blockSounds == null) {
            blockSounds = new HashMap<Integer, Block.SoundType>();
            customSounds.put(block, blockSounds);
        }
        blockSounds.put(metadata, sound);
    }
}

