/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.sounds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.sounds.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class SoundHelper {
    public static final String SOUND_LOCOMOTIVE_STEAM_WHISTLE = "railcraft:locomotive.steam.whistle";
    public static final String SOUND_LOCOMOTIVE_ELECTRIC_WHISTLE = "railcraft:locomotive.electric.whistle";
    public static final String SOUND_STEAM_BURST = "railcraft:machine.steamburst";
    public static final String SOUND_STEAM_HISS = "railcraft:machine.steamhiss";
    private static final Map<String, Integer> soundLimiterClient = new HashMap<String, Integer>();
    private static final Map<String, Integer> soundLimiterServer = new HashMap<String, Integer>();

    private static Map<String, Integer> getSoundLimiter() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return soundLimiterClient;
        }
        return soundLimiterServer;
    }

    private static boolean canPlaySound(String name) {
        if (!RailcraftConfig.playSounds()) {
            return false;
        }
        Integer limit = SoundHelper.getSoundLimiter().get(name);
        return limit == null || limit <= 10;
    }

    private static void incrementLimiter(String name) {
        Integer limit = SoundHelper.getSoundLimiter().get(name);
        if (limit == null) {
            limit = 0;
        }
        Integer n = limit;
        Integer n2 = limit = Integer.valueOf(limit + 1);
        SoundHelper.getSoundLimiter().put(name, limit);
    }

    public static void decrementLimiters() {
        for (Map.Entry<String, Integer> entry : SoundHelper.getSoundLimiter().entrySet()) {
            Integer limit = entry.getValue();
            if (limit <= 0) continue;
            Integer n = limit;
            Integer n2 = limit = Integer.valueOf(limit - 1);
            entry.setValue(limit);
        }
    }

    public static void playSound(World world, int x, int y, int z, String name, float volume, float pitch) {
        if (SoundHelper.canPlaySound(name)) {
            SoundHelper.incrementLimiter(name);
            world.playSoundEffect((double)x, (double)y, (double)z, name, volume, pitch);
        }
    }

    public static void playSoundClient(World world, int x, int y, int z, String name, float volume, float pitch) {
        if (SoundHelper.canPlaySound(name)) {
            SoundHelper.incrementLimiter(name);
            world.playSound((double)x, (double)y, (double)z, name, volume, pitch, false);
        }
    }

    public static void playSoundAtEntity(Entity entity, String name, float volume, float pitch) {
        if (SoundHelper.canPlaySound(name)) {
            SoundHelper.incrementLimiter(name);
            entity.worldObj.playSoundAtEntity(entity, name, volume, pitch);
        }
    }

    public static void playBlockSound(World world, int x, int y, int z, String soundName, float volume, float pitch, Block block, int meta) {
        if (world != null && soundName != null) {
            Block.SoundType sound;
            if (soundName.contains("railcraft") && (sound = SoundRegistry.getSound(block, meta)) != null) {
                String newName = soundName.contains("dig") ? sound.getBreakSound() : (soundName.contains("step") ? sound.getStepResourcePath() : sound.func_150496_b());
                world.playSoundEffect((double)x, (double)y, (double)z, newName, volume, pitch * sound.getPitch());
            }
            world.playSoundEffect((double)x, (double)y, (double)z, soundName, volume, pitch);
        }
    }

    public static void playFX(World world, EntityPlayer player, int id, int x, int y, int z, int data) {
        if (RailcraftConfig.playSounds()) {
            world.playAuxSFXAtEntity(player, id, x, y, z, data);
        }
    }
}

