/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.tracks.TrackFactory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTileEntity
extends RailcraftPacket {
    private RailcraftTileEntity tile;

    public PacketTileEntity() {
    }

    public PacketTileEntity(RailcraftTileEntity tile) {
        this.tile = tile;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.tile.xCoord);
        data.writeInt(this.tile.yCoord);
        data.writeInt(this.tile.zCoord);
        data.writeShort(this.tile.getId());
        this.tile.writePacketData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        World world = Game.getWorld();
        if (world == null) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        short id = data.readShort();
        if (id < 0 || y < 0 || !world.blockExists(x, y, z)) {
            return;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof RailcraftTileEntity) {
            this.tile = (RailcraftTileEntity)te;
            if (this.tile.getId() != id) {
                this.tile = null;
            }
        } else {
            this.tile = null;
        }
        if (this.tile == null) {
            Block block = world.getBlock(x, y, z);
            Block blockTrack = RailcraftBlocks.getBlockTrack();
            if (blockTrack != null && blockTrack == block) {
                this.tile = TrackFactory.makeTrackTile(id);
                world.setTileEntity(x, y, z, (TileEntity)this.tile);
            } else {
                world.removeTileEntity(x, y, z);
                te = world.getTileEntity(x, y, z);
                if (te instanceof RailcraftTileEntity) {
                    this.tile = (RailcraftTileEntity)te;
                }
            }
        }
        if (this.tile == null) {
            return;
        }
        try {
            this.tile.readPacketData(data);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            if (Game.IS_DEBUG) {
                throw ex;
            }
            Game.logThrowable("Exception in PacketTileEntity.readData:", ex, new Object[0]);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.TILE_ENTITY.ordinal();
    }
}

