/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketGuiString
extends RailcraftPacket {
    private byte windowId;
    private byte dataId;
    private String str;

    public PacketGuiString() {
    }

    public PacketGuiString(int windowId, int dataId, String str) {
        this.windowId = (byte)windowId;
        this.dataId = (byte)dataId;
        this.str = str;
    }

    public void sendPacket(EntityPlayerMP player) {
        PacketDispatcher.sendToPlayer(this, player);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.windowId);
        data.writeByte(this.dataId);
        data.writeUTF(this.str);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.windowId = data.readByte();
        this.dataId = data.readByte();
        this.str = data.readUTF();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().thePlayer;
        if (player.openContainer instanceof RailcraftContainer && player.openContainer.windowId == this.windowId) {
            ((RailcraftContainer)player.openContainer).updateString(this.dataId, this.str);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.GUI_STRING.ordinal();
    }
}

