/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.manipulators;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryManipulator {
    private final IInventory inv;

    public static InventoryManipulator get(IInventory inv) {
        return new InventoryManipulator(inv);
    }

    protected InventoryManipulator(IInventory inv) {
        this.inv = inv;
    }

    protected Iterable<IInvSlot> getSlots() {
        return InventoryIterator.getIterable(this.inv);
    }

    public boolean canAddStack(ItemStack stack) {
        return this.tryAddStack(stack) == null;
    }

    public ItemStack tryAddStack(ItemStack stack) {
        return this.addStack(stack, false);
    }

    public ItemStack addStack(ItemStack stack) {
        return this.addStack(stack, true);
    }

    private ItemStack addStack(ItemStack stack, boolean doAdd) {
        if (stack == null || stack.stackSize <= 0) {
            return null;
        }
        stack = stack.copy();
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inv.getSizeInventory());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inv.getSizeInventory());
        for (IInvSlot slot : InventoryIterator.getIterable(this.inv)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(filledSlots, stack, injected, doAdd);
        injected = this.tryPut(emptySlots, stack, injected, doAdd);
        stack.stackSize -= injected;
        if (stack.stackSize <= 0) {
            return null;
        }
        return stack;
    }

    private int tryPut(List<IInvSlot> slots, ItemStack stack, int injected, boolean doAdd) {
        if (injected >= stack.stackSize) {
            return injected;
        }
        for (IInvSlot slot : slots) {
            int used;
            ItemStack stackInSlot = slot.getStackInSlot();
            if (stackInSlot != null && !InvTools.isItemEqual(stackInSlot, stack) || (used = this.addToSlot(slot, stack, stack.stackSize - injected, doAdd)) <= 0 || (injected += used) < stack.stackSize) continue;
            return injected;
        }
        return injected;
    }

    private int addToSlot(IInvSlot slot, ItemStack stack, int available, boolean doAdd) {
        int max = Math.min(stack.getMaxStackSize(), this.inv.getInventoryStackLimit());
        ItemStack stackInSlot = slot.getStackInSlot();
        if (stackInSlot == null) {
            int wanted = Math.min(available, max);
            if (doAdd) {
                stackInSlot = stack.copy();
                stackInSlot.stackSize = wanted;
                slot.setStackInSlot(stackInSlot);
            }
            return wanted;
        }
        if (!InvTools.isItemEqual(stack, stackInSlot)) {
            return 0;
        }
        int wanted = max - stackInSlot.stackSize;
        if (wanted <= 0) {
            return 0;
        }
        if (wanted > available) {
            wanted = available;
        }
        if (doAdd) {
            stackInSlot.stackSize += wanted;
            slot.setStackInSlot(stackInSlot);
        }
        return wanted;
    }

    public boolean canRemoveItem(IStackFilter filter) {
        return this.tryRemoveItem(filter) == null;
    }

    public ItemStack tryRemoveItem(IStackFilter filter) {
        for (IInvSlot slot : this.getSlots()) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.stackSize <= 0 || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            ItemStack output = stack.copy();
            output.stackSize = 1;
            return output;
        }
        return null;
    }

    public ItemStack removeItem(IStackFilter filter) {
        for (IInvSlot slot : this.getSlots()) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.stackSize <= 0 || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            return slot.decreaseStackInSlot();
        }
        return null;
    }

    public boolean canRemoveItems(IStackFilter filter, int maxAmount) {
        List<ItemStack> outputList = this.removeItem(filter, maxAmount, false);
        int found = 0;
        for (ItemStack stack : outputList) {
            found += stack.stackSize;
        }
        return found == maxAmount;
    }

    public List<ItemStack> removeItems(IStackFilter filter, int maxAmount) {
        return this.removeItem(filter, maxAmount, true);
    }

    private List<ItemStack> removeItem(IStackFilter filter, int maxAmount, boolean doRemove) {
        int amountNeeded = maxAmount;
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        for (IInvSlot slot : this.getSlots()) {
            if (amountNeeded <= 0) break;
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.stackSize <= 0 || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            ItemStack output = stack.copy();
            if (output.stackSize >= amountNeeded) {
                output.stackSize = amountNeeded;
                if (doRemove) {
                    stack.stackSize -= amountNeeded;
                    if (stack.stackSize <= 0) {
                        stack = null;
                    }
                    slot.setStackInSlot(stack);
                }
                amountNeeded = 0;
                outputList.add(output);
                continue;
            }
            amountNeeded -= output.stackSize;
            outputList.add(output);
            if (!doRemove) continue;
            slot.setStackInSlot(null);
        }
        return outputList;
    }

    public ItemStack moveItem(IInventory dest, IStackFilter filter) {
        InventoryManipulator imDest = InventoryManipulator.get(dest);
        for (IInvSlot slot : this.getSlots()) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.stackSize <= 0 || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            stack = stack.copy();
            stack.stackSize = 1;
            if ((stack = imDest.addStack(stack)) != null) continue;
            return slot.decreaseStackInSlot();
        }
        return null;
    }
}

