/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StandaloneInventory
implements IInventory,
Iterable<ItemStack> {
    private Callback callback;
    private final String name;
    private ItemStack[] contents;

    public StandaloneInventory(int size, String name, IInventory callback) {
        this.name = name;
        this.contents = new ItemStack[size];
        this.callback = callback == null ? null : new InventoryCallback(callback);
    }

    public StandaloneInventory(int size, String name, RailcraftTileEntity callback) {
        this.name = name;
        this.contents = new ItemStack[size];
        this.callback = callback == null ? null : new TileCallback(callback);
    }

    public StandaloneInventory(int size, String name, Callback callback) {
        this.name = name;
        this.contents = new ItemStack[size];
        this.callback = callback;
    }

    public StandaloneInventory(int size, IInventory callback) {
        this(size, null, callback);
    }

    public StandaloneInventory(int size, RailcraftTileEntity callback) {
        this(size, null, callback);
    }

    public StandaloneInventory(int size, String name) {
        this(size, name, (RailcraftTileEntity)null);
    }

    public StandaloneInventory(int size) {
        this(size, null, (RailcraftTileEntity)null);
    }

    public int getSizeInventory() {
        return this.contents.length;
    }

    public ItemStack getStackInSlot(int i) {
        return this.contents[i];
    }

    public ItemStack decrStackSize(int i, int j) {
        if (this.contents[i] != null) {
            if (this.contents[i].stackSize <= j) {
                ItemStack itemstack = this.contents[i];
                this.contents[i] = null;
                this.markDirty();
                return itemstack;
            }
            ItemStack itemstack1 = this.contents[i].splitStack(j);
            if (this.contents[i].stackSize <= 0) {
                this.contents[i] = null;
            }
            this.markDirty();
            return itemstack1;
        }
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.contents[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public String getInventoryName() {
        if (this.name != null) {
            return LocalizationPlugin.translate(this.name);
        }
        if (this.callback != null) {
            return this.callback.getInventoryName();
        }
        return this.invTypeName();
    }

    protected String invTypeName() {
        return "Standalone";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        if (this.callback != null) {
            this.callback.markDirty();
        }
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.callback != null) {
            return this.callback.isUseableByPlayer(entityplayer);
        }
        return true;
    }

    public void openInventory() {
        if (this.callback != null) {
            this.callback.openInventory();
        }
    }

    public void closeInventory() {
        if (this.callback != null) {
            this.callback.closeInventory();
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    public void writeToNBT(String tag, NBTTagCompound data) {
        InvTools.writeInvToNBT(this, tag, data);
    }

    public void readFromNBT(String tag, NBTTagCompound data) {
        InvTools.readInvFromNBT(this, tag, data);
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])this.contents);
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    private static class TileCallback
    extends Callback {
        private final RailcraftTileEntity inv;

        public TileCallback(RailcraftTileEntity inv) {
            this.inv = inv;
        }

        @Override
        public void markDirty() {
            this.inv.markDirty();
        }

        @Override
        public String getInventoryName() {
            return this.inv.getName();
        }
    }

    private static class InventoryCallback
    extends Callback {
        private final IInventory inv;

        public InventoryCallback(IInventory inv) {
            this.inv = inv;
        }

        @Override
        public boolean isUseableByPlayer(EntityPlayer entityplayer) {
            return this.inv.isUseableByPlayer(entityplayer);
        }

        @Override
        public void openInventory() {
            this.inv.openInventory();
        }

        @Override
        public void closeInventory() {
            this.inv.closeInventory();
        }

        @Override
        public void markDirty() {
            this.inv.markDirty();
        }

        @Override
        public String getInventoryName() {
            return this.inv.getInventoryName();
        }
    }

    public static abstract class Callback {
        public boolean isUseableByPlayer(EntityPlayer entityplayer) {
            return true;
        }

        public void openInventory() {
        }

        public void closeInventory() {
        }

        public void markDirty() {
        }

        public String getInventoryName() {
            return "Standalone";
        }
    }
}

