/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.ItemStackMap;
import mods.railcraft.common.util.inventory.ItemStackSet;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import mods.railcraft.common.util.inventory.filters.InvertedStackFilter;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.manipulators.InventoryManipulator;
import mods.railcraft.common.util.inventory.wrappers.ChestWrapper;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import mods.railcraft.common.util.inventory.wrappers.SidedInventoryMapper;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public abstract class InvTools {
    private static final String TAG_SLOT = "Slot";

    public static ItemStack makeStack(Item item, int qty, int meta) {
        if (item != null) {
            return new ItemStack(item, qty, meta);
        }
        return null;
    }

    public static ItemStack makeStack(Block block, int qty, int meta) {
        if (block != null) {
            return new ItemStack(block, qty, meta);
        }
        return null;
    }

    public static List<IInventory> getAdjacentInventories(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventories(world, i, j, k, null);
    }

    public static List<IInventory> getAdjacentInventories(World world, int i, int j, int k, Class<? extends IInventory> type) {
        ArrayList<IInventory> list = new ArrayList<IInventory>(5);
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            list.add(inv);
        }
        return list;
    }

    public static Map<Integer, IInventory> getAdjacentInventoryMap(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventoryMap(world, i, j, k, null);
    }

    public static Map<Integer, IInventory> getAdjacentInventoryMap(World world, int i, int j, int k, Class<? extends IInventory> type) {
        TreeMap<Integer, IInventory> map = new TreeMap<Integer, IInventory>();
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            map.put(side, inv);
        }
        return map;
    }

    public static IInventory getInventoryFromSide(World world, int x, int y, int z, ForgeDirection side, final Class<? extends IInventory> type, final Class<? extends IInventory> exclude) {
        return InvTools.getInventoryFromSide(world, x, y, z, side, new ITileFilter(){

            @Override
            public boolean matches(TileEntity tile) {
                if (type != null && !type.isAssignableFrom(tile.getClass())) {
                    return false;
                }
                return exclude == null || !exclude.isAssignableFrom(tile.getClass());
            }
        });
    }

    public static IInventory getInventoryFromSide(World world, int x, int y, int z, ForgeDirection side, ITileFilter filter) {
        TileEntity tile = WorldPlugin.getTileEntityOnSide(world, x, y, z, side);
        if (tile == null || !(tile instanceof IInventory) || !filter.matches(tile)) {
            return null;
        }
        return InvTools.getInventoryFromTile(tile, side.getOpposite());
    }

    public static IInventory getInventoryFromTile(TileEntity tile, ForgeDirection side) {
        if (tile == null || !(tile instanceof IInventory)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            return new ChestWrapper(chest);
        }
        return InvTools.getInventory((IInventory)tile, side);
    }

    public static IInventory getInventory(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMapper((ISidedInventory)inv, side);
        }
        return inv;
    }

    public static int[] buildSlotArray(int start, int size) {
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = start + i;
        }
        return slots;
    }

    public static EnumColor getItemColor(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (InvTools.isStackEqualToBlock(stack, Blocks.wool)) {
            return EnumColor.fromId(15 - stack.getItemDamage());
        }
        if (stack.getItem() == Items.dye) {
            return EnumColor.fromId(stack.getItemDamage());
        }
        NBTTagCompound nbt = stack.getTagCompound();
        if (nbt != null && nbt.hasKey("color")) {
            return EnumColor.fromId(nbt.getByte("color"));
        }
        return null;
    }

    public static ItemStack setItemColor(ItemStack stack, EnumColor color) {
        if (color == null) {
            return stack;
        }
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.setByte("color", (byte)color.ordinal());
        return stack;
    }

    public static boolean isSynthetic(ItemStack stack) {
        NBTTagCompound nbt = stack.getTagCompound();
        return nbt != null && nbt.hasKey("synthetic");
    }

    public static void markItemSynthetic(ItemStack stack) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.setBoolean("synthetic", true);
        NBTTagCompound display = nbt.getCompoundTag("display");
        nbt.setTag("display", (NBTBase)display);
        NBTTagList lore = display.getTagList("Lore", 8);
        display.setTag("Lore", (NBTBase)lore);
        lore.appendTag((NBTBase)new NBTTagString("\u00a77\u00a7o" + LocalizationPlugin.translate("item.synthetic")));
    }

    public static void addItemToolTip(ItemStack stack, String msg) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        NBTTagCompound display = nbt.getCompoundTag("display");
        nbt.setTag("display", (NBTBase)display);
        NBTTagList lore = display.getTagList("Lore", 8);
        display.setTag("Lore", (NBTBase)lore);
        lore.appendTag((NBTBase)new NBTTagString(msg));
    }

    @Nonnull
    public static NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.getTagCompound();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.setTagCompound(nbt);
        }
        return nbt;
    }

    @Nonnull
    public static NBTTagCompound getItemDataRailcraft(ItemStack stack) {
        NBTTagCompound railcraftTag;
        NBTTagCompound nbt = InvTools.getItemData(stack);
        if (nbt.hasKey(Railcraft.getModId())) {
            railcraftTag = nbt.getCompoundTag(Railcraft.getModId());
        } else {
            railcraftTag = new NBTTagCompound();
            nbt.setTag(Railcraft.getModId(), (NBTBase)railcraftTag);
        }
        return railcraftTag;
    }

    public static void addNBTTag(ItemStack stack, String key, String value) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.setString(key, value);
    }

    public static void addNBTTag(ItemStack stack, String key, int value) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.setInteger(key, value);
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            return stack.getItem().getContainerItem(stack);
        }
        stack.splitStack(1);
        return stack;
    }

    public static ItemStack damageItem(ItemStack stack, int damage) {
        if (!stack.isItemStackDamageable()) {
            return stack;
        }
        int curDamage = stack.getItemDamage();
        stack.setItemDamage(curDamage += damage);
        if (stack.getItemDamage() > stack.getMaxDamage()) {
            --stack.stackSize;
            stack.setItemDamage(0);
        }
        if (stack.stackSize <= 0) {
            stack = null;
        }
        return stack;
    }

    public static void dropItem(ItemStack stack, World world, double x, double y, double z) {
        if (stack == null || stack.stackSize < 1) {
            return;
        }
        EntityItem entityItem = new EntityItem(world, x, y + 1.5, z, stack);
        entityItem.delayBeforeCanPickup = 10;
        world.spawnEntityInWorld((Entity)entityItem);
    }

    public static void dropInventory(IInventory inv, World world, int x, int y, int z) {
        if (Game.isNotHost(world)) {
            return;
        }
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            InvTools.spewItem(slot.getStackInSlot(), world, x, y, z);
            slot.setStackInSlot(null);
        }
    }

    public static void dropItems(Collection<ItemStack> items, World world, int x, int y, int z) {
        if (Game.isNotHost(world)) {
            return;
        }
        for (ItemStack stack : items) {
            InvTools.spewItem(stack, world, x, y, z);
        }
    }

    private static void spewItem(ItemStack stack, World world, int x, int y, int z) {
        if (stack != null) {
            float xOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            float yOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            float zOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            while (stack.stackSize > 0) {
                int numToDrop = MiscTools.getRand().nextInt(21) + 10;
                if (numToDrop > stack.stackSize) {
                    numToDrop = stack.stackSize;
                }
                ItemStack newStack = stack.copy();
                newStack.stackSize = numToDrop;
                stack.stackSize -= numToDrop;
                EntityItem entityItem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), newStack);
                float variance = 0.05f;
                entityItem.motionX = (float)MiscTools.getRand().nextGaussian() * variance;
                entityItem.motionY = (float)MiscTools.getRand().nextGaussian() * variance + 0.2f;
                entityItem.motionZ = (float)MiscTools.getRand().nextGaussian() * variance;
                world.spawnEntityInWorld((Entity)entityItem);
            }
        }
    }

    public static boolean isInventoryEmpty(IInventory inv, ForgeDirection side) {
        return InvTools.isInventoryEmpty(InvTools.getInventory(inv, side));
    }

    public static boolean isInventoryEmpty(IInventory inv) {
        IInvSlot slot;
        ItemStack stack = null;
        Iterator<IInvSlot> iterator = InventoryIterator.getIterable(inv).iterator();
        while (iterator.hasNext() && (stack = (slot = iterator.next()).getStackInSlot()) == null) {
        }
        return stack == null;
    }

    public static boolean isAccessibleInventoryEmpty(IInventory inv, ForgeDirection side) {
        return InvTools.isInventoryEmpty(InvTools.getInventory(inv, side));
    }

    public static boolean isAccessibleInventoryEmpty(IInventory inv) {
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInventoryFull(IInventory inv, ForgeDirection side) {
        return InvTools.isInventoryFull(InvTools.getInventory(inv, side));
    }

    public static boolean isInventoryFull(IInventory inv) {
        IInvSlot slot;
        ItemStack stack = null;
        Iterator<IInvSlot> iterator = InventoryIterator.getIterable(inv).iterator();
        while (iterator.hasNext() && (stack = (slot = iterator.next()).getStackInSlot()) != null) {
        }
        return stack != null;
    }

    public static boolean isEmptySlot(IInventory inv) {
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack != null) continue;
            return true;
        }
        return false;
    }

    public static int countItems(IInventory inv) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            count += stack.stackSize;
        }
        return count;
    }

    public static int countMaxItemStackSize(IInventory inv) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            count += stack.getMaxStackSize();
        }
        return count;
    }

    public static int countItems(IInventory inv, IStackFilter filter) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.stackSize;
        }
        return count;
    }

    public static boolean numItemsMoreThan(IInventory inv, int amount) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack != null) {
                count += stack.stackSize;
            }
            if (count < amount) continue;
            return true;
        }
        return false;
    }

    public static int countItems(IInventory inv, ItemStack ... filters) {
        return InvTools.countItems(inv, new ArrayStackFilter(filters));
    }

    public static int countItems(Collection<IInventory> inventories, ItemStack ... filter) {
        int count = 0;
        for (IInventory inv : inventories) {
            count += InvTools.countItems(inv, filter);
        }
        return count;
    }

    public static int countStacks(IInventory inv) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            ++count;
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ItemStack item) {
        return InvTools.countItems(inv, item) > 0;
    }

    public static Map<ItemStack, Integer> getManifest(IInventory inv) {
        ItemStackMap<Integer> manifest = new ItemStackMap<Integer>();
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack slot = inv.getStackInSlot(i);
            if (slot == null) continue;
            Integer count = (Integer)manifest.get(slot);
            if (count == null) {
                count = 0;
            }
            count = count + slot.stackSize;
            manifest.put(slot, count);
        }
        return manifest;
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)StackFilter.ALL);
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)new ArrayStackFilter(filters));
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, IStackFilter filter) {
        InventoryManipulator imSource = InventoryManipulator.get(source);
        return imSource.moveItem(dest, filter);
    }

    public static ItemStack moveOneItem(Collection<IInventory> sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItem(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItem(Collection<IInventory> sources, IInventory dest, IStackFilter filter) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItem(inv, dest, filter);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItem(IInventory source, Collection<IInventory> destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItem(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)new InvertedStackFilter(new ArrayStackFilter(filters)));
    }

    public static ItemStack moveOneItemExcept(Collection<IInventory> sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItemExcept(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, Collection<IInventory> destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItemExcept(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static boolean isWildcard(ItemStack stack) {
        return InvTools.isWildcard(stack.getItemDamage());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static boolean isItemEqualStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (a.stackSize != b.stackSize) {
            return false;
        }
        if (a.getItemDamage() != b.getItemDamage()) {
            return false;
        }
        return a.stackTagCompound == null || a.stackTagCompound.equals((Object)b.stackTagCompound);
    }

    public static boolean isItemEqualSemiStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (a.getItemDamage() != b.getItemDamage()) {
            return false;
        }
        return a.stackTagCompound == null || a.stackTagCompound.equals((Object)b.stackTagCompound);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, true);
    }

    public static boolean isItemEqualIgnoreNBT(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, false);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (matchNBT && !ItemStack.areItemStackTagsEqual((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.getHasSubtypes()) {
            if (InvTools.isWildcard(a) || InvTools.isWildcard(b)) {
                return true;
            }
            if (a.getItemDamage() != b.getItemDamage()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isCartItemEqual(ItemStack a, ItemStack b, boolean matchDamage) {
        if (!InvTools.isItemEqual(a, b, matchDamage, false)) {
            return false;
        }
        return !a.hasDisplayName() || a.getDisplayName().equals(b.getDisplayName());
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack ... matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack stack, Collection<ItemStack> matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemGreaterOrEqualThan(ItemStack stackA, ItemStack stackB) {
        if (!InvTools.isItemEqual(stackA, stackB)) {
            return false;
        }
        return stackA.stackSize >= stackB.stackSize;
    }

    public static boolean isItemLessThanOrEqualTo(ItemStack stackA, ItemStack stackB) {
        if (!InvTools.isItemEqual(stackA, stackB)) {
            return false;
        }
        return stackA.stackSize <= stackB.stackSize;
    }

    public static ItemStack moveItemStack(ItemStack stack, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.addStack(stack);
    }

    public static ItemStack moveItemStack(ItemStack stack, Collection<IInventory> dest) {
        for (IInventory inv : dest) {
            if ((stack = InvTools.moveItemStack(stack, inv)) != null) continue;
            return null;
        }
        return stack;
    }

    public static boolean isRoomForStack(ItemStack stack, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.canAddStack(stack);
    }

    public static ItemStack[] removeItems(IInventory inv, int numItems) {
        StandaloneInventory output = new StandaloneInventory(27);
        for (int i = 0; i < inv.getSizeInventory() && numItems > 0; ++i) {
            ItemStack slot = inv.getStackInSlot(i);
            if (slot == null) continue;
            ItemStack removed = inv.decrStackSize(i, numItems);
            numItems -= removed.stackSize;
            ItemStack remainder = InvTools.moveItemStack(removed, output);
            if (remainder == null) continue;
            InvTools.moveItemStack(remainder, inv);
            numItems += remainder.stackSize;
            break;
        }
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (ItemStack stack : output.getContents()) {
            if (stack == null) continue;
            list.add(stack);
        }
        return list.toArray(new ItemStack[0]);
    }

    public static ItemStack removeOneItem(IInventory inv) {
        return InvTools.removeOneItem(inv, (IStackFilter)StackFilter.ALL);
    }

    public static ItemStack removeOneItem(IInventory inv, ItemStack ... filter) {
        return InvTools.removeOneItem(inv, (IStackFilter)new ArrayStackFilter(filter));
    }

    public static ItemStack removeOneItem(IInventory inv, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        return im.removeItem(filter);
    }

    public static ItemStack removeOneItem(Collection<IInventory> invs, IStackFilter filter) {
        for (IInventory inv : invs) {
            ItemStack stack = InvTools.removeOneItem(inv, filter);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public static boolean removeItemsAbsolute(IInventory inv, int amount, ItemStack ... filter) {
        return InvTools.removeItemsAbsolute(inv, amount, new ArrayStackFilter(filter));
    }

    public static boolean removeItemsAbsolute(IInventory inv, int amount, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        if (im.canRemoveItems(filter, amount)) {
            im.removeItems(filter, amount);
            return true;
        }
        return false;
    }

    public static ItemStack findMatchingItem(IInventory inv, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        return im.tryRemoveItem(filter);
    }

    public static Set<ItemStack> findMatchingItems(IInventory inv, IStackFilter filter) {
        ItemStackSet items = new ItemStackSet();
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.stackSize <= 0 || !filter.matches(stack)) continue;
            stack = stack.copy();
            stack.stackSize = 1;
            items.add(stack);
        }
        return items;
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.getSizeInventory(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.getStackInSlot((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.setByte(TAG_SLOT, slot);
            InvTools.writeItemToNBT(stack, itemTag);
            list.appendTag((NBTBase)itemTag);
        }
        data.setTag(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.getTagList(tag, 10);
        for (int entry = 0; entry < list.tagCount(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = list.getCompoundTagAt(entry);
            byte slot = itemTag.getByte(TAG_SLOT);
            if (slot < 0 || slot >= inv.getSizeInventory()) continue;
            ItemStack stack = InvTools.readItemFromNBT(itemTag);
            inv.setInventorySlotContents((int)slot, stack);
        }
    }

    public static void writeItemToNBT(ItemStack stack, NBTTagCompound data) {
        if (stack == null || stack.stackSize <= 0) {
            return;
        }
        if (stack.stackSize > 127) {
            stack.stackSize = 127;
        }
        stack.writeToNBT(data);
    }

    public static ItemStack readItemFromNBT(NBTTagCompound data) {
        return ItemStack.loadItemStackFromNBT((NBTTagCompound)data);
    }

    public static boolean isStackEqualToBlock(ItemStack stack, Block block) {
        if (stack == null || block == null) {
            return false;
        }
        if (stack.getItem() instanceof ItemBlock) {
            return ((ItemBlock)stack.getItem()).field_150939_a == block;
        }
        return false;
    }

    public static Block getBlockFromStack(ItemStack stack) {
        if (stack.getItem() instanceof ItemBlock) {
            return ((ItemBlock)stack.getItem()).field_150939_a;
        }
        return null;
    }

    public static ItemStack getItemFromOreDict(String oreName, int quantity) {
        if (OreDictionary.doesOreNameExist((String)oreName)) {
            ItemStack stack = ((ItemStack)OreDictionary.getOres((String)oreName).get(0)).copy();
            stack.stackSize = quantity;
            return stack;
        }
        return null;
    }
}

