/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemTicketGold;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RoutingTicketCopyRecipe
implements IRecipe {
    public boolean matches(InventoryCrafting grid, World world) {
        int numPaper = 0;
        int numTickets = 0;
        for (int slot = 0; slot < grid.getSizeInventory(); ++slot) {
            ItemStack stack = grid.getStackInSlot(slot);
            if (stack == null) continue;
            if (stack.getItem() == ItemTicketGold.item) {
                ++numTickets;
                continue;
            }
            if (stack.getItem() == Items.paper || stack.getItem() == ItemTicket.item) {
                ++numPaper;
                continue;
            }
            return false;
        }
        return numTickets == 1 && numPaper == 1;
    }

    public ItemStack getCraftingResult(InventoryCrafting grid) {
        ItemStack ticket = null;
        for (int slot = 0; slot < grid.getSizeInventory(); ++slot) {
            ItemStack stack = grid.getStackInSlot(slot);
            if (stack == null || stack.getItem() != ItemTicketGold.item) continue;
            ticket = stack;
            break;
        }
        if (ticket != null) {
            return ItemTicket.copyTicket(ticket);
        }
        return null;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return ItemTicket.getTicket();
    }
}

