/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RotorRepairRecipe
implements IRecipe {
    private static final int REPAIR_PER_BLADE = 2500;
    private final ItemStack ROTOR = RailcraftPartItems.getTurbineRotor();
    private final ItemStack BLADE = RailcraftPartItems.getTurbineBlade();

    public boolean matches(InventoryCrafting grid, World world) {
        boolean hasRotor = false;
        boolean hasBlade = false;
        for (int slot = 0; slot < grid.getSizeInventory(); ++slot) {
            ItemStack stack = grid.getStackInSlot(slot);
            if (InvTools.isItemEqual(stack, this.ROTOR)) {
                hasRotor = true;
                continue;
            }
            if (!InvTools.isItemEqual(stack, this.BLADE)) continue;
            hasBlade = true;
        }
        return hasBlade && hasRotor;
    }

    public ItemStack getCraftingResult(InventoryCrafting grid) {
        ItemStack rotor = null;
        int numBlades = 0;
        for (int slot = 0; slot < grid.getSizeInventory(); ++slot) {
            ItemStack stack = grid.getStackInSlot(slot);
            if (InvTools.isItemEqual(stack, this.ROTOR)) {
                rotor = stack.copy();
                continue;
            }
            if (!InvTools.isItemEqual(stack, this.BLADE)) continue;
            ++numBlades;
        }
        if (rotor == null) {
            return null;
        }
        int damage = rotor.getItemDamage();
        if ((damage -= 2500 * numBlades) < 0) {
            damage = 0;
        }
        rotor.setItemDamage(damage);
        return rotor;
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }
}

