/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mods.railcraft.api.crafting.IRockCrusherCraftingManager;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.item.ItemStack;

public class RockCrusherCraftingManager
implements IRockCrusherCraftingManager {
    private final List<CrusherRecipe> recipes = new ArrayList<CrusherRecipe>();

    public static IRockCrusherCraftingManager getInstance() {
        return RailcraftCraftingManager.rockCrusher;
    }

    @Override
    public List<? extends IRockCrusherRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public IRockCrusherRecipe createNewRecipe(ItemStack input, boolean matchDamage, boolean matchNBT) {
        CrusherRecipe recipe = new CrusherRecipe(input, matchDamage, matchNBT);
        this.recipes.add(recipe);
        return recipe;
    }

    @Override
    public CrusherRecipe getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        for (CrusherRecipe r : this.recipes) {
            if (!r.matchDamage || InvTools.isWildcard(r.input) || !InvTools.isItemEqual(input, r.input, true, r.matchNBT)) continue;
            return r;
        }
        for (CrusherRecipe r : this.recipes) {
            if (!InvTools.isItemEqual(input, r.input, r.matchDamage, r.matchNBT)) continue;
            return r;
        }
        return null;
    }

    public static class CrusherRecipe
    implements IRockCrusherRecipe {
        private final ItemStack input;
        private final boolean matchDamage;
        private final boolean matchNBT;
        private final List<Map.Entry<ItemStack, Float>> outputs = new ArrayList<Map.Entry<ItemStack, Float>>();

        public CrusherRecipe(ItemStack input, boolean matchDamage, boolean matchNBT) {
            this.input = input.copy();
            this.matchDamage = matchDamage;
            this.matchNBT = matchNBT;
        }

        @Override
        public ItemStack getInput() {
            return this.input.copy();
        }

        @Override
        public void addOutput(ItemStack output, float chance) {
            if (output == null) {
                return;
            }
            this.outputs.add(Maps.immutableEntry((Object)output, (Object)Float.valueOf(chance)));
        }

        @Override
        public List<Map.Entry<ItemStack, Float>> getOutputs() {
            return this.outputs;
        }

        @Override
        public List<ItemStack> getPossibleOuputs() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Map.Entry<ItemStack, Float> entry : this.outputs) {
                ItemStack output = entry.getKey();
                for (ItemStack saved : list) {
                    if (!InvTools.isItemEqual(saved, output)) continue;
                    if (saved.stackSize + output.stackSize <= saved.getMaxStackSize()) {
                        saved.stackSize += output.stackSize;
                        output = null;
                        break;
                    }
                    int diff = saved.getMaxStackSize() - saved.stackSize;
                    saved.stackSize = saved.getMaxStackSize();
                    output.stackSize -= diff;
                    break;
                }
                if (output == null) continue;
                list.add(output.copy());
            }
            return list;
        }

        @Override
        public List<ItemStack> getRandomizedOuputs() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Map.Entry<ItemStack, Float> entry : this.outputs) {
                if (!(MiscTools.getRand().nextFloat() <= entry.getValue().floatValue())) continue;
                list.add(entry.getKey().copy());
            }
            return list;
        }

        public int getNumberOfOutputs() {
            return this.outputs.size();
        }
    }
}

