/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import javax.annotation.Nullable;
import mods.railcraft.common.carts.EntityCartFiltered;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class CartFilterRecipe
implements IRecipe {
    public boolean matches(InventoryCrafting grid, World world) {
        return this.getCraftingResult(grid) != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting grid) {
        ItemStack stack;
        ItemStack cartItem = null;
        ItemStack filterItem = null;
        FilterType filterType = null;
        int cartSlot = -1;
        int itemCount = 0;
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)grid).notNull()) {
            ++itemCount;
            stack = slot.getStackInSlot();
            FilterType type = FilterType.fromCartType(EnumCart.getCartType(stack));
            if (type == null) continue;
            cartSlot = slot.getIndex();
            filterType = type;
            cartItem = stack.copy();
            cartItem.stackSize = 1;
        }
        if (filterType == null || itemCount > 2) {
            return null;
        }
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)grid).notNull()) {
            if (slot.getIndex() == cartSlot || !filterType.isAllowedFilterItem(stack = slot.getStackInSlot())) continue;
            filterItem = stack.copy();
            break;
        }
        if (cartItem == null || filterItem == null) {
            return null;
        }
        filterItem.stackSize = 1;
        return EntityCartFiltered.addFilterToCartItem(cartItem, filterItem);
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public static enum FilterType {
        Cargo(EnumCart.CARGO),
        Tank(EnumCart.TANK){

            @Override
            public boolean isAllowedFilterItem(ItemStack stack) {
                return FluidItemHelper.isFilledContainer(stack);
            }
        };

        public static FilterType[] VALUES;
        public final ICartType cartType;

        private FilterType(ICartType cartType) {
            this.cartType = cartType;
        }

        public boolean isAllowedFilterItem(ItemStack stack) {
            return true;
        }

        @Nullable
        public static FilterType fromCartType(ICartType cartType) {
            if (cartType == null) {
                return null;
            }
            for (FilterType t : VALUES) {
                if (t.cartType != cartType) continue;
                return t;
            }
            return null;
        }

        static {
            VALUES = FilterType.values();
        }
    }
}

