/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.thaumcraft;

import net.minecraft.entity.DataWatcher;
import thaumcraft.api.aspects.Aspect;

public class EssentiaTank {
    private final Aspect aspect;
    private final DataWatcher dataWatcher;
    private final int capacity;
    private final int dataId;

    public EssentiaTank(Aspect aspect, int capacity, DataWatcher dataWatcher, int dataId) {
        this.aspect = aspect;
        this.dataWatcher = dataWatcher;
        this.dataId = dataId;
        this.capacity = capacity;
        dataWatcher.addObject(dataId, (Object)0);
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public int getAmount() {
        return this.dataWatcher.getWatchableObjectShort(this.dataId);
    }

    public void setAmount(int amount) {
        this.dataWatcher.updateObject(this.dataId, (Object)((short)amount));
    }

    public int fill(int amount, boolean doAdd) {
        if (amount < 0) {
            return 0;
        }
        int remainder = 0;
        int contents = this.getAmount() + amount;
        if (contents > this.capacity) {
            remainder = contents - this.capacity;
            contents = this.capacity;
        }
        if (doAdd) {
            this.setAmount(contents);
        }
        return remainder;
    }

    public boolean contains(int amount) {
        return this.getAmount() >= amount;
    }

    public boolean remove(int amount, boolean doRemove) {
        if (amount < 0) {
            return false;
        }
        if (this.contains(amount)) {
            if (doRemove) {
                int contents = this.getAmount() - amount;
                this.setAmount(Math.max(contents, 0));
            }
            return true;
        }
        return false;
    }
}

