/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import cpw.mods.fml.common.Optional;
import forestry.api.storage.IBackpackDefinition;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockRailcraftStairs;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.plugins.forestry.BaseBackpack;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Optional.Interface(iface="forestry.api.storage.IBackpackDefinition", modid="Forestry")
public class IcemanBackpack
extends BaseBackpack
implements IBackpackDefinition {
    private static IcemanBackpack instance;
    private static final ItemStack SNOWBALL;
    private static final ItemStack SNOWBLOCK;
    private static final String INV_TAG = "Items";

    public static IcemanBackpack getInstance() {
        if (instance == null) {
            instance = new IcemanBackpack();
        }
        return instance;
    }

    protected IcemanBackpack() {
    }

    public void setup() {
        this.addItem(Blocks.snow);
        this.addItem(Blocks.snow_layer);
        this.addItem(Blocks.ice);
        this.addItem(EnumWallAlpha.SNOW.getItem());
        this.addItem(EnumWallAlpha.ICE.getItem());
        this.addItem(BlockRailcraftStairs.getItem(EnumBlockMaterial.SNOW));
        this.addItem(BlockRailcraftStairs.getItem(EnumBlockMaterial.ICE));
        this.addItem(BlockRailcraftSlab.getItem(EnumBlockMaterial.SNOW));
        this.addItem(BlockRailcraftSlab.getItem(EnumBlockMaterial.ICE));
        this.addItem(Items.snowball);
    }

    public void compactInventory(ItemStack backpack) {
        StandaloneInventory inv = new StandaloneInventory(45);
        NBTTagCompound data = backpack.getTagCompound();
        if (data == null) {
            return;
        }
        InvTools.readInvFromNBT(inv, INV_TAG, data);
        int numSnowballs = InvTools.countItems((IInventory)inv, SNOWBALL);
        if (numSnowballs >= 16) {
            for (int i = 0; i < 4; ++i) {
                InvTools.removeOneItem((IInventory)inv, SNOWBALL);
            }
            if (InvTools.moveItemStack(new ItemStack(Blocks.snow), inv) == null) {
                InvTools.writeInvToNBT(inv, INV_TAG, data);
            }
        } else if (numSnowballs < 8 && InvTools.removeOneItem((IInventory)inv, SNOWBLOCK) != null && InvTools.moveItemStack(new ItemStack(Items.snowball, 4), inv) == null) {
            InvTools.writeInvToNBT(inv, INV_TAG, data);
        }
    }

    public String getKey() {
        return "ICEMAN";
    }

    public int getPrimaryColour() {
        return 0xFFFFFF;
    }

    public int getSecondaryColour() {
        return 0xFFFFFF;
    }

    static {
        SNOWBALL = new ItemStack(Items.snowball);
        SNOWBLOCK = new ItemStack(Blocks.snow);
    }
}

