/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemNotepad;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.crafting.CartFilterRecipe;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ModuleTransport
extends RailcraftModule {
    @Override
    public void initFirst() {
        EnumCart cart;
        EnumMachineGamma liquidUnloader;
        EnumMachineGamma liquidLoader;
        ItemStack detector;
        EnumMachineGamma itemUnloader;
        EnumMachineGamma itemLoader;
        EnumMachineAlpha alpha;
        ItemNotepad.registerItem();
        if (ItemNotepad.item != null) {
            ItemStack magGlass = ItemMagnifyingGlass.getItem();
            CraftingPlugin.addShapedRecipe(new ItemStack((Item)ItemNotepad.item), "IF", "XP", Character.valueOf('I'), new ItemStack(Items.dye, 1, 0), Character.valueOf('F'), Items.feather, Character.valueOf('X'), magGlass, Character.valueOf('P'), Items.paper);
        }
        if ((alpha = EnumMachineAlpha.TANK_WATER).register()) {
            CraftingPlugin.addShapedRecipe(alpha.getItem(6), "WWW", "ISI", "WWW", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "slimeball", Character.valueOf('W'), "plankWood");
        }
        this.initIronTank();
        this.initSteelTank();
        EnumMachineBeta voidChest = EnumMachineBeta.VOID_CHEST;
        if (voidChest.register()) {
            CraftingPlugin.addShapedRecipe(voidChest.getItem(), "OOO", "OPO", "OOO", Character.valueOf('O'), new ItemStack(Blocks.obsidian), Character.valueOf('P'), new ItemStack(Items.ender_pearl));
        }
        if ((itemLoader = EnumMachineGamma.ITEM_LOADER).register()) {
            ItemStack stack = itemLoader.getItem();
            ItemStack detector2 = EnumDetector.ITEM.getItem();
            if (detector2 == null) {
                detector2 = new ItemStack(Blocks.stone_pressure_plate);
            }
            CraftingPlugin.addShapedRecipe(stack, "SSS", "SLS", "SDS", Character.valueOf('S'), "cobblestone", Character.valueOf('D'), detector2, Character.valueOf('L'), new ItemStack((Block)Blocks.hopper));
            itemLoader = EnumMachineGamma.ITEM_LOADER_ADVANCED;
            if (itemLoader.register()) {
                CraftingPlugin.addShapedRecipe(itemLoader.getItem(), "IRI", "RLR", "ISI", Character.valueOf('I'), "ingotSteel", Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), RailcraftToolItems.getSteelShovel(), Character.valueOf('L'), stack);
            }
        }
        if ((itemUnloader = EnumMachineGamma.ITEM_UNLOADER).register()) {
            ItemStack stack = itemUnloader.getItem();
            detector = EnumDetector.ITEM.getItem();
            if (detector == null) {
                detector = new ItemStack(Blocks.stone_pressure_plate);
            }
            CraftingPlugin.addShapedRecipe(stack, "SSS", "SDS", "SLS", Character.valueOf('S'), "cobblestone", Character.valueOf('D'), detector, Character.valueOf('L'), new ItemStack((Block)Blocks.hopper));
            itemUnloader = EnumMachineGamma.ITEM_UNLOADER_ADVANCED;
            if (itemUnloader.register()) {
                CraftingPlugin.addShapedRecipe(itemUnloader.getItem(), "IRI", "RLR", "ISI", Character.valueOf('I'), "ingotSteel", Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), RailcraftToolItems.getSteelShovel(), Character.valueOf('L'), stack);
            }
        }
        if ((liquidLoader = EnumMachineGamma.FLUID_LOADER).register()) {
            detector = EnumDetector.TANK.getItem();
            if (detector == null) {
                detector = new ItemStack(Blocks.stone_pressure_plate);
            }
            CraftingPlugin.addShapedRecipe(liquidLoader.getItem(), "GLG", "G G", "GDG", Character.valueOf('D'), detector, Character.valueOf('G'), "blockGlassColorless", Character.valueOf('L'), Blocks.hopper);
        }
        if ((liquidUnloader = EnumMachineGamma.FLUID_UNLOADER).register()) {
            ItemStack detector3 = EnumDetector.TANK.getItem();
            if (detector3 == null) {
                detector3 = new ItemStack(Blocks.stone_pressure_plate);
            }
            CraftingPlugin.addShapedRecipe(liquidUnloader.getItem(), "GDG", "G G", "GLG", Character.valueOf('D'), detector3, Character.valueOf('G'), "blockGlassColorless", Character.valueOf('L'), Blocks.hopper);
        }
        if ((cart = EnumCart.TANK).setup()) {
            if (EnumMachineBeta.TANK_IRON_GAUGE.isAvaliable()) {
                CraftingPlugin.addShapedRecipe(cart.getCartItem(), "T", "M", Character.valueOf('T'), EnumMachineBeta.TANK_IRON_GAUGE.getItem(), Character.valueOf('M'), Items.minecart);
                cart.setContents(this.getColorTank(EnumMachineBeta.TANK_IRON_GAUGE, EnumColor.WHITE, 1));
            } else {
                CraftingPlugin.addShapedRecipe(cart.getCartItem(), "GGG", "GMG", "GGG", Character.valueOf('G'), "blockGlassColorless", Character.valueOf('M'), Items.minecart);
                cart.setContents(new ItemStack(Blocks.glass, 8));
            }
            CraftingPlugin.addShapelessRecipe(new ItemStack(Items.minecart), cart.getCartItem());
            CraftingPlugin.addRecipe(new CartFilterRecipe());
        }
        if ((cart = EnumCart.CARGO).setup()) {
            CraftingPlugin.addShapedRecipe(cart.getCartItem(), "B", "M", Character.valueOf('B'), Blocks.trapped_chest, Character.valueOf('M'), Items.minecart);
            CraftingPlugin.addShapelessRecipe(new ItemStack(Items.minecart), cart.getCartItem());
            CraftingPlugin.addRecipe(new CartFilterRecipe());
        }
    }

    private void addColorRecipes(EnumMachineBeta type) {
        for (EnumColor color : EnumColor.VALUES) {
            ItemStack output = this.getColorTank(type, color, 8);
            CraftingPlugin.addShapedRecipe(output, "OOO", "ODO", "OOO", Character.valueOf('O'), type.getItem(), Character.valueOf('D'), color.getDye());
        }
    }

    private ItemStack getColorTank(EnumMachineBeta type, EnumColor color, int qty) {
        ItemStack stack = type.getItem(qty);
        return InvTools.setItemColor(stack, color);
    }

    private boolean defineTank(EnumMachineBeta type, Object ... recipe) {
        if (type.register()) {
            this.addColorRecipes(type);
            CraftingPlugin.addShapedRecipe(this.getColorTank(type, EnumColor.WHITE, 8), recipe);
            return true;
        }
        return false;
    }

    private boolean defineIronTank(EnumMachineBeta type, Object ... recipe) {
        if (this.defineTank(type, recipe)) {
            RailcraftCraftingManager.blastFurnace.addRecipe(type.getItem(), true, false, 640, RailcraftItem.nugget.getStack(4, ItemNugget.EnumNugget.STEEL));
            return true;
        }
        return false;
    }

    private void initIronTank() {
        this.defineIronTank(EnumMachineBeta.TANK_IRON_WALL, "PP", "PP", Character.valueOf('P'), RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.IRON));
        this.defineIronTank(EnumMachineBeta.TANK_IRON_GAUGE, "GPG", "PGP", "GPG", Character.valueOf('P'), RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.IRON), Character.valueOf('G'), "paneGlassColorless");
        this.defineIronTank(EnumMachineBeta.TANK_IRON_VALVE, "GPG", "PLP", "GPG", Character.valueOf('P'), RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.IRON), Character.valueOf('L'), new ItemStack(Blocks.lever), Character.valueOf('G'), new ItemStack(Blocks.iron_bars));
    }

    private void initSteelTank() {
        this.defineTank(EnumMachineBeta.TANK_STEEL_WALL, "PP", "PP", Character.valueOf('P'), RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.STEEL));
        this.defineTank(EnumMachineBeta.TANK_STEEL_GAUGE, "GPG", "PGP", "GPG", Character.valueOf('P'), RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.STEEL), Character.valueOf('G'), "paneGlassColorless");
        this.defineTank(EnumMachineBeta.TANK_STEEL_VALVE, "GPG", "PLP", "GPG", Character.valueOf('P'), RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.STEEL), Character.valueOf('L'), new ItemStack(Blocks.lever), Character.valueOf('G'), new ItemStack(Blocks.iron_bars));
    }
}

