/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.items.ItemGear;
import mods.railcraft.common.items.ItemIngot;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.ItemRail;
import mods.railcraft.common.items.ItemRailbed;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.ItemRebar;
import mods.railcraft.common.items.ItemSignalLabel;
import mods.railcraft.common.items.ItemSignalLamp;
import mods.railcraft.common.items.ItemTie;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum RailcraftItem {
    circuit(ItemCircuit.class, "part.circuit"),
    dust(ItemDust.class, "dust"),
    gear(ItemGear.class, "part.gear"),
    ingot(ItemIngot.class, "ingot"),
    nugget(ItemNugget.class, "nugget"),
    plate(ItemPlate.class, "part.plate"),
    rail(ItemRail.class, "part.rail"),
    railbed(ItemRailbed.class, "part.railbed"),
    rebar(ItemRebar.class, "part.rebar", "ingotIron"),
    signalLabel(ItemSignalLabel.class, "tool.signal.label"),
    signalLamp(ItemSignalLamp.class, "part.signal.lamp", Blocks.redstone_lamp),
    tie(ItemTie.class, "part.tie");

    public static final RailcraftItem[] VALUES;
    private final Class<? extends ItemRailcraft> itemClass;
    private final String tag;
    private final Object altRecipeObject;
    private ItemRailcraft item;

    private RailcraftItem(Class<? extends ItemRailcraft> itemClass, String tag) {
        this.itemClass = itemClass;
        this.tag = tag;
        this.altRecipeObject = null;
    }

    private RailcraftItem(Class<? extends ItemRailcraft> itemClass, String tag, Object alt) {
        this.itemClass = itemClass;
        this.tag = tag;
        this.altRecipeObject = alt;
    }

    public void registerItem() {
        if (this.item != null) {
            return;
        }
        if (this.isEnabled()) {
            try {
                this.item = this.itemClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Invalid Item Constructor");
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Invalid Item Constructor");
            }
            this.item.setUnlocalizedName("railcraft." + this.tag);
            RailcraftRegistry.register(this.item);
            this.item.initItem();
            this.item.defineRecipes();
        }
    }

    public boolean isItemEqual(ItemStack stack) {
        return stack != null && this.item == stack.getItem();
    }

    public boolean isItemEqual(Item i) {
        return i != null && this.item == i;
    }

    public ItemRailcraft item() {
        return this.item;
    }

    public ItemStack getWildcard() {
        return this.getStack(1, Short.MAX_VALUE);
    }

    public ItemStack getStack() {
        return this.getStack(1, 0);
    }

    public ItemStack getStack(int qty) {
        return this.getStack(qty, 0);
    }

    public ItemStack getStack(int qty, int meta) {
        this.registerItem();
        if (this.item == null) {
            return null;
        }
        return new ItemStack((Item)this.item, qty, meta);
    }

    private void checkMetaObject(IItemMetaEnum meta) {
        if (meta == null || meta.getItemClass() != this.itemClass) {
            throw new RuntimeException("Incorrect Item Meta object used.");
        }
    }

    public ItemStack getStack(IItemMetaEnum meta) {
        return this.getStack(1, meta);
    }

    public ItemStack getStack(int qty, IItemMetaEnum meta) {
        this.checkMetaObject(meta);
        return this.getStack(qty, meta.ordinal());
    }

    public Object getRecipeObject() {
        this.registerItem();
        if (this.item != null) {
            return this.item.getRecipeObject(null);
        }
        Object obj = this.altRecipeObject;
        if (obj instanceof ItemStack) {
            obj = ((ItemStack)obj).copy();
        }
        return obj;
    }

    public Object getRecipeObject(IItemMetaEnum meta) {
        this.checkMetaObject(meta);
        this.registerItem();
        if (this.item != null) {
            return this.item.getRecipeObject(meta);
        }
        Object obj = meta.getAlternate();
        if (obj == null) {
            obj = this.altRecipeObject;
        }
        if (obj instanceof ItemStack) {
            obj = ((ItemStack)obj).copy();
        }
        return obj;
    }

    public boolean isEnabled() {
        return RailcraftConfig.isItemEnabled(this.tag);
    }

    public static void definePostRecipes() {
        for (RailcraftItem type : VALUES) {
            if (type.item == null) continue;
            type.item.definePostRecipes();
        }
    }

    static {
        VALUES = RailcraftItem.values();
    }
}

