/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemTie
extends ItemRailcraft {
    public ItemTie() {
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        for (EnumTie tie : EnumTie.VALUES) {
            tie.icon = iconRegister.registerIcon("railcraft:part.tie." + tie.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void getSubItems(Item id, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    public IIcon getIconFromDamage(int damage) {
        if (damage >= EnumTie.VALUES.length) {
            return EnumTie.WOOD.icon;
        }
        return EnumTie.VALUES[damage].icon;
    }

    public String getUnlocalizedName(ItemStack stack) {
        String base = super.getUnlocalizedName();
        switch (stack.getItemDamage()) {
            case 1: {
                return base + ".stone";
            }
        }
        return base + ".wood";
    }

    @Override
    public void initItem() {
        for (EnumTie tie : EnumTie.VALUES) {
            RailcraftRegistry.register(new ItemStack((Item)this, 1, tie.ordinal()));
        }
        LootPlugin.addLootRailway(RailcraftItem.tie.getStack(1, EnumTie.WOOD), 4, 16, "tie.wood");
        LootPlugin.addLootWorkshop(RailcraftItem.tie.getStack(1, EnumTie.STONE), 4, 16, "tie.stone");
    }

    @Override
    public void defineRecipes() {
        ItemStack tieStone = RailcraftItem.tie.getStack(1, EnumTie.STONE);
        CraftingPlugin.addShapedRecipe(tieStone, new Object[]{" O ", "###", Character.valueOf('O'), RailcraftItem.rebar, Character.valueOf('#'), new ItemStack((Block)Blocks.stone_slab, 1, 0)});
    }

    @Override
    public void definePostRecipes() {
        ItemStack tieWood = RailcraftItem.tie.getStack(1, EnumTie.WOOD);
        for (ItemStack container : FluidHelper.getContainersFilledWith(Fluids.CREOSOTE.getB(1))) {
            CraftingPlugin.addShapedRecipe(tieWood, " O ", "###", Character.valueOf('O'), container, Character.valueOf('#'), "slabWood");
        }
    }

    public static enum EnumTie implements IItemMetaEnum
    {
        WOOD("slabWood"),
        STONE(Blocks.stone_slab);

        public static final EnumTie[] VALUES;
        private IIcon icon;
        private Object alternate;

        private EnumTie(Object alt) {
            this.alternate = alt;
        }

        @Override
        public Object getAlternate() {
            return this.alternate;
        }

        @Override
        public Class<? extends ItemRailcraft> getItemClass() {
            return ItemTie.class;
        }

        static {
            VALUES = EnumTie.values();
        }
    }
}

