/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemMaterials;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class ItemOveralls
extends ItemArmor {
    private static final ItemStack BLUE_CLOTH = new ItemStack(Blocks.wool, 1, 3);
    private static final String TEXTURE = "railcraft:textures/entities/armor/overalls.png";

    public static boolean isPlayerWearing(EntityPlayer player) {
        ItemStack pants = player.getCurrentArmor(MiscTools.ArmorSlots.LEGS.ordinal());
        return pants != null && pants.getItem() instanceof ItemOveralls;
    }

    public ItemOveralls() {
        super(ItemMaterials.OVERALLS, 0, 2);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:" + MiscTools.cleanTag(this.getUnlocalizedName()));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TEXTURE;
    }

    public boolean getIsRepairable(ItemStack itemToRepair, ItemStack stack) {
        return InvTools.isItemEqual(stack, BLUE_CLOTH);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        super.addInformation(stack, player, info, adv);
        ToolTip tip = ToolTip.buildToolTip(stack.getUnlocalizedName() + ".tip", new String[0]);
        if (tip != null) {
            info.addAll(tip.convertToStrings());
        }
    }
}

