/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import buildcraft.api.tools.IToolWrench;
import ic2.api.item.IBoxable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.common.blocks.tracks.BlockTrackElevator;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.enchantment.RailcraftEnchantments;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCrowbar
extends ItemTool
implements IToolCrowbar,
IBoxable,
IToolWrench {
    public static final byte BOOST_DAMAGE = 3;
    private static final String ITEM_TAG = "railcraft.tool.crowbar";
    private static Item item;
    private final Set<Class<? extends Block>> shiftRotations = new HashSet<Class<? extends Block>>();
    private final Set<Class<? extends Block>> bannedRotations = new HashSet<Class<? extends Block>>();

    public static void registerItem() {
        if (item == null && RailcraftConfig.isItemEnabled(ITEM_TAG)) {
            item = new ItemCrowbar(Item.ToolMaterial.IRON);
            item.setUnlocalizedName(ITEM_TAG);
            RailcraftRegistry.register(item);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), " RI", "RIR", "IR ", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dyeRed");
            LootPlugin.addLootTool(new ItemStack(item), 1, 1, ITEM_TAG);
            LootPlugin.addLootWorkshop(new ItemStack(item), 1, 1, ITEM_TAG);
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    public static Item getItemObj() {
        return item;
    }

    protected ItemCrowbar(Item.ToolMaterial material) {
        super(3.0f, material, new HashSet<Block>(Arrays.asList(Blocks.rail, Blocks.detector_rail, Blocks.golden_rail, Blocks.activator_rail)));
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
        this.shiftRotations.add(BlockLever.class);
        this.shiftRotations.add(BlockButton.class);
        this.shiftRotations.add(BlockChest.class);
        this.bannedRotations.add(BlockRailBase.class);
        this.setHarvestLevel("crowbar", 2);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (TrackTools.isRailBlock(block)) {
            return this.efficiencyOnProperMaterial;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:" + MiscTools.cleanTag(this.getUnlocalizedName()));
    }

    private boolean isShiftRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> shift : this.shiftRotations) {
            if (!shift.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private boolean isBannedRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> banned : this.bannedRotations) {
            if (!banned.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.getBlock(x, y, z);
        if (block == null) {
            return false;
        }
        if (player.isSneaking() != this.isShiftRotation(block.getClass())) {
            return false;
        }
        if (this.isBannedRotation(block.getClass())) {
            return false;
        }
        if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.swingItem();
            return !world.isRemote;
        }
        return false;
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        int level;
        EntityPlayer player;
        if (!world.isRemote && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).isSneaking() && (level = EnchantmentHelper.getEnchantmentLevel((int)RailcraftEnchantments.destruction.effectId, (ItemStack)stack) * 2 + 1) > 0) {
            this.checkBlocks(world, level, x, y, z, entity, stack);
        }
        return super.onBlockDestroyed(stack, world, block, x, y, z, entity);
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.getCurrentEquippedItem().damageItem(1, (EntityLivingBase)player);
        player.swingItem();
    }

    @Override
    public boolean canWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        return true;
    }

    @Override
    public void onWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        crowbar.damageItem(1, (EntityLivingBase)player);
        player.swingItem();
    }

    @Override
    public boolean canLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return player.isSneaking();
    }

    @Override
    public void onLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.damageItem(1, (EntityLivingBase)player);
        player.swingItem();
    }

    @Override
    public boolean canBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return !player.isSneaking();
    }

    @Override
    public void onBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.damageItem(3, (EntityLivingBase)player);
        player.swingItem();
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean advInfo) {
        info.add(LocalizationPlugin.translate("item.railcraft.tool.crowbar.tip"));
    }

    private void removeAndDrop(World world, int x, int y, int z, Block block, EntityLivingBase entity, ItemStack stack, int meta) {
        if (!ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)entity).theItemInWorldManager.getGameType(), (EntityPlayerMP)((EntityPlayerMP)entity), (int)x, (int)y, (int)z).isCanceled()) {
            InvTools.dropItems(block.getDrops(world, x, y, z, meta, EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)stack)), world, x, y, z);
            world.setBlockToAir(x, y, z);
        }
    }

    private void removeExtraBlocks(World world, int level, int x, int y, int z, Block block, EntityLivingBase entity, ItemStack stack, int meta) {
        if (level > 0) {
            this.removeAndDrop(world, x, y, z, block, entity, stack, meta);
            this.checkBlocks(world, level, x, y, z, entity, stack);
        }
    }

    private void checkBlock(World world, int level, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        int meta = WorldPlugin.getBlockMetadata((IBlockAccess)world, x, y, z);
        if (TrackTools.isRailBlock(block) || block instanceof BlockTrackElevator || block.isToolEffective("crowbar", meta)) {
            this.removeExtraBlocks(world, level - 1, x, y, z, block, entity, stack, meta);
        }
    }

    private void checkBlocks(World world, int level, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        this.checkBlock(world, level, x, y, z - 1, entity, stack);
        this.checkBlock(world, level, x, y + 1, z - 1, entity, stack);
        this.checkBlock(world, level, x, y - 1, z - 1, entity, stack);
        this.checkBlock(world, level, x, y, z + 1, entity, stack);
        this.checkBlock(world, level, x, y + 1, z + 1, entity, stack);
        this.checkBlock(world, level, x, y - 1, z + 1, entity, stack);
        this.checkBlock(world, level, x + 1, y, z, entity, stack);
        this.checkBlock(world, level, x + 1, y + 1, z, entity, stack);
        this.checkBlock(world, level, x + 1, y - 1, z, entity, stack);
        this.checkBlock(world, level, x - 1, y, z, entity, stack);
        this.checkBlock(world, level, x - 1, y + 1, z, entity, stack);
        this.checkBlock(world, level, x - 1, y - 1, z, entity, stack);
        this.checkBlock(world, level, x, y + 1, z, entity, stack);
        this.checkBlock(world, level, x, y - 1, z, entity, stack);
    }
}

