/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemCircuit
extends ItemRailcraft {
    public ItemCircuit() {
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public void initItem() {
        for (EnumCircuit circuit : EnumCircuit.VALUES) {
            ItemStack stack = new ItemStack((Item)this, 1, circuit.ordinal());
            RailcraftRegistry.register(stack);
        }
    }

    @Override
    public void defineRecipes() {
        CraftingPlugin.addShapedRecipe(new ItemStack((Item)this, 1, EnumCircuit.CONTROLLER.ordinal()), " #S", "BGR", "SRL", Character.valueOf('L'), "gemLapis", Character.valueOf('#'), Items.repeater, Character.valueOf('G'), "ingotGold", Character.valueOf('S'), new ItemStack(Blocks.wool, 1, 14), Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "slimeball");
        CraftingPlugin.addShapedRecipe(new ItemStack((Item)this, 1, EnumCircuit.RECEIVER.ordinal()), " #S", "BGR", "SRL", Character.valueOf('L'), "gemLapis", Character.valueOf('#'), Items.repeater, Character.valueOf('G'), "ingotGold", Character.valueOf('S'), new ItemStack(Blocks.wool, 1, 13), Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "slimeball");
        CraftingPlugin.addShapedRecipe(new ItemStack((Item)this, 1, EnumCircuit.SIGNAL.ordinal()), " #S", "BGR", "SRL", Character.valueOf('L'), "gemLapis", Character.valueOf('#'), Items.repeater, Character.valueOf('G'), "ingotGold", Character.valueOf('S'), new ItemStack(Blocks.wool, 1, 4), Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "slimeball");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        for (EnumCircuit gear : EnumCircuit.VALUES) {
            gear.icon = iconRegister.registerIcon("railcraft:part.circuit." + gear.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (EnumCircuit circuit : EnumCircuit.VALUES) {
            list.add(new ItemStack((Item)this, 1, circuit.ordinal()));
        }
    }

    public IIcon getIconFromDamage(int damage) {
        if (damage >= EnumCircuit.VALUES.length) {
            return EnumCircuit.RECEIVER.icon;
        }
        return EnumCircuit.VALUES[damage].icon;
    }

    public String getUnlocalizedName(ItemStack stack) {
        int damage = stack.getItemDamage();
        if (damage < 0 || damage >= EnumCircuit.VALUES.length) {
            return "";
        }
        switch (EnumCircuit.VALUES[damage]) {
            case CONTROLLER: {
                return "item.railcraft.part.circuit.controller";
            }
            case RECEIVER: {
                return "item.railcraft.part.circuit.receiver";
            }
            case SIGNAL: {
                return "item.railcraft.part.circuit.signal";
            }
        }
        return "";
    }

    public static enum EnumCircuit implements IItemMetaEnum
    {
        CONTROLLER(Items.comparator),
        RECEIVER(Blocks.redstone_torch),
        SIGNAL(Items.repeater);

        public static EnumCircuit[] VALUES;
        private IIcon icon;
        private Object alternate;

        private EnumCircuit(Object alt) {
            this.alternate = alt;
        }

        @Override
        public Object getAlternate() {
            return this.alternate;
        }

        @Override
        public Class<? extends ItemRailcraft> getItemClass() {
            return ItemCircuit.class;
        }

        static {
            VALUES = EnumCircuit.values();
        }
    }
}

