/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.gui.slots.SlotRailcraft;
import mods.railcraft.common.gui.widgets.Widget;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class RailcraftContainer
extends Container {
    private final IInventory callback;
    private final List<Widget> widgets = new ArrayList<Widget>();

    public RailcraftContainer(IInventory inv) {
        this.callback = inv;
    }

    public RailcraftContainer() {
        this.callback = null;
    }

    public List<Widget> getElements() {
        return this.widgets;
    }

    public void addSlot(Slot slot) {
        this.addSlotToContainer(slot);
    }

    public void addWidget(Widget widget) {
        widget.addToContainer(this);
        this.widgets.add(widget);
    }

    public void addCraftingToCrafters(ICrafting player) {
        super.addCraftingToCrafters(player);
        for (Widget widget : this.widgets) {
            widget.initWidget(player);
        }
    }

    public final void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.sendUpdateToClient();
            for (Widget widget : this.widgets) {
                for (ICrafting player : this.crafters) {
                    widget.updateWidget(player);
                }
            }
        }
    }

    public void sendUpdateToClient() {
    }

    public void sendWidgetDataToClient(Widget widget, ICrafting player, byte[] data) {
        PacketBuilder.instance().sendGuiWidgetPacket((EntityPlayerMP)player, this.windowId, this.widgets.indexOf(widget), data);
    }

    public void handleWidgetClientData(int widgetId, DataInputStream data) throws IOException {
        this.widgets.get(widgetId).handleClientPacketData(data);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateString(byte id, String data) {
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.callback == null) {
            return true;
        }
        return this.callback.isUseableByPlayer(entityplayer);
    }

    public ItemStack slotClick(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotNum < 0 ? null : (Slot)this.inventorySlots.get(slotNum);
        if (slot instanceof SlotRailcraft && ((SlotRailcraft)slot).isPhantom()) {
            return this.slotClickPhantom((SlotRailcraft)slot, mouseButton, modifier, player);
        }
        return super.slotClick(slotNum, mouseButton, modifier, player);
    }

    private ItemStack slotClickPhantom(SlotRailcraft slot, int mouseButton, int modifier, EntityPlayer player) {
        ItemStack stack = null;
        if (mouseButton == 2) {
            if (slot.canAdjustPhantom()) {
                slot.putStack(null);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.inventory;
            slot.onSlotChanged();
            ItemStack stackSlot = slot.getStack();
            ItemStack stackHeld = playerInv.getItemStack();
            if (stackSlot != null) {
                stack = stackSlot.copy();
            }
            if (stackSlot == null) {
                if (stackHeld != null && slot.isItemValid(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            } else if (stackHeld == null) {
                this.adjustPhantomSlot(slot, mouseButton, modifier);
                slot.onPickupFromSlot(player, playerInv.getItemStack());
            } else if (slot.isItemValid(stackHeld)) {
                if (InvTools.isItemEqual(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, modifier);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(SlotRailcraft slot, int mouseButton, int modifier) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.getStack();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.stackSize + 1) / 2 : stackSlot.stackSize * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.stackSize - 1 : stackSlot.stackSize + 1;
        }
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        stackSlot.stackSize = stackSize;
        if (stackSlot.stackSize <= 0) {
            slot.putStack(null);
        }
    }

    protected void fillPhantomSlot(SlotRailcraft slot, ItemStack stackHeld, int mouseButton, int modifier) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.stackSize : 1;
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        ItemStack phantomStack = stackHeld.copy();
        phantomStack.stackSize = stackSize;
        slot.putStack(phantomStack);
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.isStackable()) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot == null || !InvTools.isItemEqual(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.stackSize + stackToShift.stackSize;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                if (resultingStackSize <= max) {
                    stackToShift.stackSize = 0;
                    stackInSlot.stackSize = resultingStackSize;
                    slot.onSlotChanged();
                    changed = true;
                    continue;
                }
                if (stackInSlot.stackSize >= max) continue;
                stackToShift.stackSize -= max - stackInSlot.stackSize;
                stackInSlot.stackSize = max;
                slot.onSlotChanged();
                changed = true;
            }
        }
        if (stackToShift.stackSize > 0) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                stackInSlot = stackToShift.copy();
                stackInSlot.stackSize = Math.min(stackToShift.stackSize, max);
                stackToShift.stackSize -= stackInSlot.stackSize;
                slot.putStack(stackInSlot);
                slot.onSlotChanged();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            SlotRailcraft slotRailcraft;
            Slot slot = (Slot)this.inventorySlots.get(machineIndex);
            if (slot instanceof SlotRailcraft && ((slotRailcraft = (SlotRailcraft)slot).isPhantom() || !slotRailcraft.canShift()) || !slot.isItemValid(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        int numSlots = this.inventorySlots.size();
        if (slot != null && slot.getHasStack()) {
            ItemStack stackInSlot = slot.getStack();
            originalStack = stackInSlot.copy();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.onSlotChange(stackInSlot, originalStack);
            if (stackInSlot.stackSize <= 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (stackInSlot.stackSize == originalStack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(player, stackInSlot);
        }
        return originalStack;
    }
}

