/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotSecure;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.widgets.Widget;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerRouting
extends RailcraftContainer {
    private final IRouter router;
    private final InventoryPlayer playerInv;
    private int lastLockState;
    private int lastRoutingState;
    public String ownerName;
    public boolean canLock = false;
    private final SlotSecure slotTicket;
    public RoutingLogic logic;
    public Widget errorElement;

    public ContainerRouting(InventoryPlayer playerInv, IRouter route) {
        super(route.getInventory());
        this.router = route;
        this.playerInv = playerInv;
        this.errorElement = new Widget(16, 24, 176, 0, 16, 16){

            @Override
            public ToolTip getToolTip() {
                if (ContainerRouting.this.router.getLogic() != null && ContainerRouting.this.router.getLogic().getError() != null) {
                    return ContainerRouting.this.router.getLogic().getError().getToolTip();
                }
                return null;
            }
        };
        this.errorElement.hidden = true;
        this.addWidget(this.errorElement);
        this.slotTicket = new SlotSecure(ItemRoutingTable.FILTER, route.getInventory(), 0, 35, 24){

            public void onSlotChanged() {
                super.onSlotChanged();
                ContainerRouting.this.router.resetLogic();
            }
        };
        this.slotTicket.setToolTips(ToolTip.buildToolTip("routing.tip.slot", new String[0]));
        this.addSlot(this.slotTicket);
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)playerInv, k + i * 9 + 9, 8 + k * 18, 78 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)playerInv, j, 8 + j * 18, 136));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 0, this.router.getLockController().getCurrentState());
        icrafting.sendProgressBarUpdate((Container)this, 1, this.router.getRoutingController().getCurrentState());
        this.canLock = PlayerPlugin.isOwnerOrOp(this.router.getOwner(), this.playerInv.player);
        this.slotTicket.locked = this.router.isSecure() && !this.canLock;
        icrafting.sendProgressBarUpdate((Container)this, 2, this.canLock ? 1 : 0);
        String username = this.router.getOwner().getName();
        if (username != null) {
            PacketBuilder.instance().sendGuiStringPacket((EntityPlayerMP)icrafting, this.windowId, 0, username);
        }
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            int railwayType;
            ICrafting var2 = (ICrafting)this.crafters.get(var1);
            int lock = this.router.getLockController().getCurrentState();
            if (this.lastLockState != lock) {
                var2.sendProgressBarUpdate((Container)this, 0, lock);
            }
            if (this.lastRoutingState == (railwayType = this.router.getRoutingController().getCurrentState())) continue;
            var2.sendProgressBarUpdate((Container)this, 1, railwayType);
        }
        this.lastLockState = this.router.getLockController().getCurrentState();
        this.lastRoutingState = this.router.getRoutingController().getCurrentState();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        switch (id) {
            case 0: {
                this.router.getLockController().setCurrentState(value);
                break;
            }
            case 1: {
                this.router.getRoutingController().setCurrentState(value);
                break;
            }
            case 2: {
                this.canLock = value == 1;
            }
        }
        this.slotTicket.locked = this.router.isSecure() && !this.canLock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateString(byte id, String data) {
        switch (id) {
            case 0: {
                this.ownerName = data;
            }
        }
    }
}

