/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.carts.EntityLocomotiveSteamSolid;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.gui.containers.ContainerLocomotive;
import mods.railcraft.common.gui.slots.SlotFuel;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotWaterLimited;
import mods.railcraft.common.gui.widgets.FluidGaugeWidget;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;

public class ContainerLocomotiveSteamSolid
extends ContainerLocomotive {
    private final EntityLocomotiveSteamSolid loco;
    private double lastBurnTime;
    private double lastItemBurnTime;
    private double lastHeat;

    private ContainerLocomotiveSteamSolid(InventoryPlayer playerInv, EntityLocomotiveSteamSolid loco) {
        super(playerInv, loco, 205);
        this.loco = loco;
    }

    public static ContainerLocomotiveSteamSolid make(InventoryPlayer playerInv, EntityLocomotiveSteamSolid loco) {
        ContainerLocomotiveSteamSolid con = new ContainerLocomotiveSteamSolid(playerInv, loco);
        con.init();
        return con;
    }

    @Override
    public void defineSlotsAndWidgets() {
        this.addWidget(new FluidGaugeWidget(this.loco.getTankManager().get(0), 116, 23, 176, 0, 16, 47));
        this.addWidget(new FluidGaugeWidget(this.loco.getTankManager().get(1), 17, 23, 176, 0, 16, 47));
        this.addWidget(new IndicatorWidget(this.loco.boiler.heatIndicator, 40, 25, 176, 61, 6, 43));
        this.addSlot(new SlotWaterLimited((IInventory)this.loco, 0, 143, 21));
        this.addSlot(new SlotOutput((IInventory)this.loco, 1, 143, 56));
        this.addSlot(new SlotFuel((IInventory)this.loco, 2, 62, 39));
        this.addSlot(new SlotFuel((IInventory)this.loco, 3, 89, 20));
        this.addSlot(new SlotFuel((IInventory)this.loco, 4, 89, 38));
        this.addSlot(new SlotFuel((IInventory)this.loco, 5, 89, 56));
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.initGuiData(this, icrafting, 0);
            tMan.initGuiData(this, icrafting, 1);
        }
        icrafting.sendProgressBarUpdate((Container)this, 20, (int)Math.round(this.loco.boiler.burnTime));
        icrafting.sendProgressBarUpdate((Container)this, 21, (int)Math.round(this.loco.boiler.currentItemBurnTime));
        icrafting.sendProgressBarUpdate((Container)this, 22, (int)Math.round(this.loco.boiler.getHeat()));
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.updateGuiData(this, this.crafters, 0);
            tMan.updateGuiData(this, this.crafters, 1);
        }
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.crafters.get(var1);
            if (this.lastBurnTime != this.loco.boiler.burnTime) {
                var2.sendProgressBarUpdate((Container)this, 20, (int)Math.round(this.loco.boiler.burnTime));
            }
            if (this.lastItemBurnTime != this.loco.boiler.currentItemBurnTime) {
                var2.sendProgressBarUpdate((Container)this, 21, (int)Math.round(this.loco.boiler.currentItemBurnTime));
            }
            if (this.lastHeat == this.loco.boiler.getHeat()) continue;
            var2.sendProgressBarUpdate((Container)this, 22, (int)Math.round(this.loco.boiler.getHeat()));
        }
        this.lastBurnTime = this.loco.boiler.burnTime;
        this.lastItemBurnTime = this.loco.boiler.currentItemBurnTime;
        this.lastHeat = this.loco.boiler.getHeat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        super.updateProgressBar(id, value);
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.processGuiUpdate(id, value);
        }
        switch (id) {
            case 20: {
                this.loco.boiler.burnTime = value;
                break;
            }
            case 21: {
                this.loco.boiler.currentItemBurnTime = value;
                break;
            }
            case 22: {
                this.loco.boiler.setHeat(value);
            }
        }
    }
}

