/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.electricity.IElectricMinecart;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import mods.railcraft.common.gui.containers.ContainerLocomotive;
import mods.railcraft.common.gui.widgets.ChargeIndicator;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class ContainerLocomotiveElectric
extends ContainerLocomotive {
    private final EntityLocomotiveElectric loco;
    private final IElectricMinecart.ChargeHandler chargeHandler;
    private final ChargeIndicator chargeIndicator;
    private double lastCharge;

    private ContainerLocomotiveElectric(InventoryPlayer playerInv, EntityLocomotiveElectric loco) {
        super(playerInv, loco, 161);
        this.loco = loco;
        this.chargeHandler = loco.getChargeHandler();
        this.chargeIndicator = new ChargeIndicator(5000.0);
    }

    public static ContainerLocomotiveElectric make(InventoryPlayer playerInv, EntityLocomotiveElectric loco) {
        ContainerLocomotiveElectric con = new ContainerLocomotiveElectric(playerInv, loco);
        con.init();
        return con;
    }

    @Override
    public void defineSlotsAndWidgets() {
        this.addWidget(new IndicatorWidget(this.chargeIndicator, 57, 20, 176, 0, 62, 8, false));
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 20, (int)Math.round(this.chargeHandler.getCharge()));
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.crafters.get(var1);
            if (this.lastCharge == this.chargeHandler.getCharge()) continue;
            var2.sendProgressBarUpdate((Container)this, 21, (int)Math.round(this.chargeHandler.getCharge()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        super.updateProgressBar(id, value);
        switch (id) {
            case 20: {
                this.chargeIndicator.setCharge(value);
                break;
            }
            case 21: {
                this.chargeIndicator.updateCharge(value);
            }
        }
    }
}

