/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotStackFilter;
import mods.railcraft.common.gui.slots.SlotUntouchable;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerLocomotive
extends RailcraftContainer {
    private final EntityLocomotive loco;
    protected final InventoryPlayer playerInv;
    private EntityLocomotive.LocoSpeed lastSpeed;
    private EntityLocomotive.LocoMode lastMode;
    private int lastLockState;
    private final int guiHeight;
    public String ownerName;

    ContainerLocomotive(InventoryPlayer playerInv, EntityLocomotive loco, int guiHeight) {
        super((IInventory)loco);
        this.loco = loco;
        this.playerInv = playerInv;
        this.guiHeight = guiHeight;
    }

    public static ContainerLocomotive make(InventoryPlayer playerInv, EntityLocomotive loco) {
        ContainerLocomotive con = new ContainerLocomotive(playerInv, loco, 161);
        con.init();
        return con;
    }

    public final void init() {
        this.defineSlotsAndWidgets();
        SlotStackFilter slotTicket = new SlotStackFilter(ItemTicket.FILTER, (IInventory)this.loco, this.loco.getSizeInventory() - 2, 116, this.guiHeight - 111){

            @Override
            public int getSlotStackLimit() {
                return 1;
            }
        };
        slotTicket.setToolTips(ToolTip.buildToolTip("gui.locomotive.tip.slot.ticket", new String[0]));
        this.addSlot(slotTicket);
        this.addSlot(new SlotUntouchable((IInventory)this.loco, this.loco.getSizeInventory() - 1, 134, this.guiHeight - 111));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)this.playerInv, k + i * 9 + 9, 8 + k * 18, this.guiHeight - 82 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)this.playerInv, j, 8 + j * 18, this.guiHeight - 24));
        }
    }

    public void defineSlotsAndWidgets() {
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 10, this.loco.getSpeed().ordinal());
        icrafting.sendProgressBarUpdate((Container)this, 11, this.loco.getMode().ordinal());
        icrafting.sendProgressBarUpdate((Container)this, 12, this.loco.getLockController().getCurrentState());
        icrafting.sendProgressBarUpdate((Container)this, 13, PlayerPlugin.isOwnerOrOp(this.loco.getOwner(), this.playerInv.player) ? 1 : 0);
        String oName = this.loco.getOwner().getName();
        if (oName != null) {
            PacketBuilder.instance().sendGuiStringPacket((EntityPlayerMP)icrafting, this.windowId, 0, oName);
        }
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (Object crafter : this.crafters) {
            int lock;
            EntityLocomotive.LocoMode mode;
            ICrafting var2 = (ICrafting)crafter;
            EntityLocomotive.LocoSpeed speed = this.loco.getSpeed();
            if (this.lastSpeed != speed) {
                var2.sendProgressBarUpdate((Container)this, 10, speed.ordinal());
            }
            if (this.lastMode != (mode = this.loco.getMode())) {
                var2.sendProgressBarUpdate((Container)this, 11, mode.ordinal());
            }
            if (this.lastLockState == (lock = this.loco.getLockController().getCurrentState())) continue;
            var2.sendProgressBarUpdate((Container)this, 12, lock);
        }
        this.lastSpeed = this.loco.getSpeed();
        this.lastMode = this.loco.getMode();
        this.lastLockState = this.loco.getLockController().getCurrentState();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        switch (id) {
            case 10: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.VALUES[value];
                break;
            }
            case 11: {
                this.loco.clientMode = EntityLocomotive.LocoMode.VALUES[value];
                break;
            }
            case 12: {
                this.loco.getLockController().setCurrentState(value);
                break;
            }
            case 13: {
                this.loco.clientCanLock = value == 1;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateString(byte id, String data) {
        switch (id) {
            case 0: {
                this.ownerName = data;
            }
        }
    }
}

